<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/speech/v2/cloud_speech.proto

namespace Google\Cloud\Speech\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents the metadata of a long-running operation.
 *
 * Generated from protobuf message <code>google.cloud.speech.v2.OperationMetadata</code>
 */
class OperationMetadata extends \Google\Protobuf\Internal\Message
{
    /**
     * The time the operation was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    private $create_time = null;
    /**
     * The time the operation was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    private $update_time = null;
    /**
     * The resource path for the target of the operation.
     *
     * Generated from protobuf field <code>string resource = 3;</code>
     */
    private $resource = '';
    /**
     * The method that triggered the operation.
     *
     * Generated from protobuf field <code>string method = 4;</code>
     */
    private $method = '';
    /**
     * The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     * Generated from protobuf field <code>string kms_key_name = 6 [(.google.api.resource_reference) = {</code>
     */
    private $kms_key_name = '';
    /**
     * The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     *
     * Generated from protobuf field <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = {</code>
     */
    private $kms_key_version_name = '';
    /**
     * The percent progress of the Operation. Values can range from 0-100. If the
     * value is 100, then the operation is finished.
     *
     * Generated from protobuf field <code>int32 progress_percent = 22;</code>
     */
    private $progress_percent = 0;
    protected $request;
    protected $metadata;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Protobuf\Timestamp $create_time
     *           The time the operation was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           The time the operation was last updated.
     *     @type string $resource
     *           The resource path for the target of the operation.
     *     @type string $method
     *           The method that triggered the operation.
     *     @type string $kms_key_name
     *           The [KMS key
     *           name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     *           the content of the Operation is encrypted. The expected format is
     *           `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *     @type string $kms_key_version_name
     *           The [KMS key version
     *           name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     *           with which content of the Operation is encrypted. The expected format is
     *           `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     *     @type \Google\Cloud\Speech\V2\BatchRecognizeRequest $batch_recognize_request
     *           The BatchRecognizeRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\CreateRecognizerRequest $create_recognizer_request
     *           The CreateRecognizerRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\UpdateRecognizerRequest $update_recognizer_request
     *           The UpdateRecognizerRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\DeleteRecognizerRequest $delete_recognizer_request
     *           The DeleteRecognizerRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\UndeleteRecognizerRequest $undelete_recognizer_request
     *           The UndeleteRecognizerRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\CreateCustomClassRequest $create_custom_class_request
     *           The CreateCustomClassRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\UpdateCustomClassRequest $update_custom_class_request
     *           The UpdateCustomClassRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\DeleteCustomClassRequest $delete_custom_class_request
     *           The DeleteCustomClassRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\UndeleteCustomClassRequest $undelete_custom_class_request
     *           The UndeleteCustomClassRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\CreatePhraseSetRequest $create_phrase_set_request
     *           The CreatePhraseSetRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\UpdatePhraseSetRequest $update_phrase_set_request
     *           The UpdatePhraseSetRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\DeletePhraseSetRequest $delete_phrase_set_request
     *           The DeletePhraseSetRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\UndeletePhraseSetRequest $undelete_phrase_set_request
     *           The UndeletePhraseSetRequest that spawned the Operation.
     *     @type \Google\Cloud\Speech\V2\UpdateConfigRequest $update_config_request
     *           The UpdateConfigRequest that spawned the Operation.
     *     @type int $progress_percent
     *           The percent progress of the Operation. Values can range from 0-100. If the
     *           value is 100, then the operation is finished.
     *     @type \Google\Cloud\Speech\V2\BatchRecognizeMetadata $batch_recognize_metadata
     *           Metadata specific to the BatchRecognize method.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Speech\V2\CloudSpeech::initOnce();
        parent::__construct($data);
    }

    /**
     * The time the operation was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 1;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * The time the operation was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 1;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * The time the operation was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 2;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * The time the operation was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 2;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * The resource path for the target of the operation.
     *
     * Generated from protobuf field <code>string resource = 3;</code>
     * @return string
     */
    public function getResource()
    {
        return $this->resource;
    }

    /**
     * The resource path for the target of the operation.
     *
     * Generated from protobuf field <code>string resource = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource = $var;

        return $this;
    }

    /**
     * The method that triggered the operation.
     *
     * Generated from protobuf field <code>string method = 4;</code>
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }

    /**
     * The method that triggered the operation.
     *
     * Generated from protobuf field <code>string method = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setMethod($var)
    {
        GPBUtil::checkString($var, True);
        $this->method = $var;

        return $this;
    }

    /**
     * The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     * Generated from protobuf field <code>string kms_key_name = 6 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getKmsKeyName()
    {
        return $this->kms_key_name;
    }

    /**
     * The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     * Generated from protobuf field <code>string kms_key_name = 6 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_name = $var;

        return $this;
    }

    /**
     * The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     *
     * Generated from protobuf field <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getKmsKeyVersionName()
    {
        return $this->kms_key_version_name;
    }

    /**
     * The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     *
     * Generated from protobuf field <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyVersionName($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_version_name = $var;

        return $this;
    }

    /**
     * The BatchRecognizeRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
     * @return \Google\Cloud\Speech\V2\BatchRecognizeRequest|null
     */
    public function getBatchRecognizeRequest()
    {
        return $this->readOneof(8);
    }

    public function hasBatchRecognizeRequest()
    {
        return $this->hasOneof(8);
    }

    /**
     * The BatchRecognizeRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
     * @param \Google\Cloud\Speech\V2\BatchRecognizeRequest $var
     * @return $this
     */
    public function setBatchRecognizeRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\BatchRecognizeRequest::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * The CreateRecognizerRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
     * @return \Google\Cloud\Speech\V2\CreateRecognizerRequest|null
     */
    public function getCreateRecognizerRequest()
    {
        return $this->readOneof(9);
    }

    public function hasCreateRecognizerRequest()
    {
        return $this->hasOneof(9);
    }

    /**
     * The CreateRecognizerRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
     * @param \Google\Cloud\Speech\V2\CreateRecognizerRequest $var
     * @return $this
     */
    public function setCreateRecognizerRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\CreateRecognizerRequest::class);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * The UpdateRecognizerRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
     * @return \Google\Cloud\Speech\V2\UpdateRecognizerRequest|null
     */
    public function getUpdateRecognizerRequest()
    {
        return $this->readOneof(10);
    }

    public function hasUpdateRecognizerRequest()
    {
        return $this->hasOneof(10);
    }

    /**
     * The UpdateRecognizerRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
     * @param \Google\Cloud\Speech\V2\UpdateRecognizerRequest $var
     * @return $this
     */
    public function setUpdateRecognizerRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\UpdateRecognizerRequest::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * The DeleteRecognizerRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
     * @return \Google\Cloud\Speech\V2\DeleteRecognizerRequest|null
     */
    public function getDeleteRecognizerRequest()
    {
        return $this->readOneof(11);
    }

    public function hasDeleteRecognizerRequest()
    {
        return $this->hasOneof(11);
    }

    /**
     * The DeleteRecognizerRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
     * @param \Google\Cloud\Speech\V2\DeleteRecognizerRequest $var
     * @return $this
     */
    public function setDeleteRecognizerRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\DeleteRecognizerRequest::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * The UndeleteRecognizerRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;</code>
     * @return \Google\Cloud\Speech\V2\UndeleteRecognizerRequest|null
     */
    public function getUndeleteRecognizerRequest()
    {
        return $this->readOneof(12);
    }

    public function hasUndeleteRecognizerRequest()
    {
        return $this->hasOneof(12);
    }

    /**
     * The UndeleteRecognizerRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;</code>
     * @param \Google\Cloud\Speech\V2\UndeleteRecognizerRequest $var
     * @return $this
     */
    public function setUndeleteRecognizerRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\UndeleteRecognizerRequest::class);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * The CreateCustomClassRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;</code>
     * @return \Google\Cloud\Speech\V2\CreateCustomClassRequest|null
     */
    public function getCreateCustomClassRequest()
    {
        return $this->readOneof(13);
    }

    public function hasCreateCustomClassRequest()
    {
        return $this->hasOneof(13);
    }

    /**
     * The CreateCustomClassRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;</code>
     * @param \Google\Cloud\Speech\V2\CreateCustomClassRequest $var
     * @return $this
     */
    public function setCreateCustomClassRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\CreateCustomClassRequest::class);
        $this->writeOneof(13, $var);

        return $this;
    }

    /**
     * The UpdateCustomClassRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;</code>
     * @return \Google\Cloud\Speech\V2\UpdateCustomClassRequest|null
     */
    public function getUpdateCustomClassRequest()
    {
        return $this->readOneof(14);
    }

    public function hasUpdateCustomClassRequest()
    {
        return $this->hasOneof(14);
    }

    /**
     * The UpdateCustomClassRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;</code>
     * @param \Google\Cloud\Speech\V2\UpdateCustomClassRequest $var
     * @return $this
     */
    public function setUpdateCustomClassRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\UpdateCustomClassRequest::class);
        $this->writeOneof(14, $var);

        return $this;
    }

    /**
     * The DeleteCustomClassRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;</code>
     * @return \Google\Cloud\Speech\V2\DeleteCustomClassRequest|null
     */
    public function getDeleteCustomClassRequest()
    {
        return $this->readOneof(15);
    }

    public function hasDeleteCustomClassRequest()
    {
        return $this->hasOneof(15);
    }

    /**
     * The DeleteCustomClassRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;</code>
     * @param \Google\Cloud\Speech\V2\DeleteCustomClassRequest $var
     * @return $this
     */
    public function setDeleteCustomClassRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\DeleteCustomClassRequest::class);
        $this->writeOneof(15, $var);

        return $this;
    }

    /**
     * The UndeleteCustomClassRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;</code>
     * @return \Google\Cloud\Speech\V2\UndeleteCustomClassRequest|null
     */
    public function getUndeleteCustomClassRequest()
    {
        return $this->readOneof(16);
    }

    public function hasUndeleteCustomClassRequest()
    {
        return $this->hasOneof(16);
    }

    /**
     * The UndeleteCustomClassRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;</code>
     * @param \Google\Cloud\Speech\V2\UndeleteCustomClassRequest $var
     * @return $this
     */
    public function setUndeleteCustomClassRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\UndeleteCustomClassRequest::class);
        $this->writeOneof(16, $var);

        return $this;
    }

    /**
     * The CreatePhraseSetRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
     * @return \Google\Cloud\Speech\V2\CreatePhraseSetRequest|null
     */
    public function getCreatePhraseSetRequest()
    {
        return $this->readOneof(17);
    }

    public function hasCreatePhraseSetRequest()
    {
        return $this->hasOneof(17);
    }

    /**
     * The CreatePhraseSetRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
     * @param \Google\Cloud\Speech\V2\CreatePhraseSetRequest $var
     * @return $this
     */
    public function setCreatePhraseSetRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\CreatePhraseSetRequest::class);
        $this->writeOneof(17, $var);

        return $this;
    }

    /**
     * The UpdatePhraseSetRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
     * @return \Google\Cloud\Speech\V2\UpdatePhraseSetRequest|null
     */
    public function getUpdatePhraseSetRequest()
    {
        return $this->readOneof(18);
    }

    public function hasUpdatePhraseSetRequest()
    {
        return $this->hasOneof(18);
    }

    /**
     * The UpdatePhraseSetRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
     * @param \Google\Cloud\Speech\V2\UpdatePhraseSetRequest $var
     * @return $this
     */
    public function setUpdatePhraseSetRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\UpdatePhraseSetRequest::class);
        $this->writeOneof(18, $var);

        return $this;
    }

    /**
     * The DeletePhraseSetRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
     * @return \Google\Cloud\Speech\V2\DeletePhraseSetRequest|null
     */
    public function getDeletePhraseSetRequest()
    {
        return $this->readOneof(19);
    }

    public function hasDeletePhraseSetRequest()
    {
        return $this->hasOneof(19);
    }

    /**
     * The DeletePhraseSetRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
     * @param \Google\Cloud\Speech\V2\DeletePhraseSetRequest $var
     * @return $this
     */
    public function setDeletePhraseSetRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\DeletePhraseSetRequest::class);
        $this->writeOneof(19, $var);

        return $this;
    }

    /**
     * The UndeletePhraseSetRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;</code>
     * @return \Google\Cloud\Speech\V2\UndeletePhraseSetRequest|null
     */
    public function getUndeletePhraseSetRequest()
    {
        return $this->readOneof(20);
    }

    public function hasUndeletePhraseSetRequest()
    {
        return $this->hasOneof(20);
    }

    /**
     * The UndeletePhraseSetRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;</code>
     * @param \Google\Cloud\Speech\V2\UndeletePhraseSetRequest $var
     * @return $this
     */
    public function setUndeletePhraseSetRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\UndeletePhraseSetRequest::class);
        $this->writeOneof(20, $var);

        return $this;
    }

    /**
     * The UpdateConfigRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];</code>
     * @return \Google\Cloud\Speech\V2\UpdateConfigRequest|null
     * @deprecated
     */
    public function getUpdateConfigRequest()
    {
        @trigger_error('update_config_request is deprecated.', E_USER_DEPRECATED);
        return $this->readOneof(21);
    }

    public function hasUpdateConfigRequest()
    {
        @trigger_error('update_config_request is deprecated.', E_USER_DEPRECATED);
        return $this->hasOneof(21);
    }

    /**
     * The UpdateConfigRequest that spawned the Operation.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];</code>
     * @param \Google\Cloud\Speech\V2\UpdateConfigRequest $var
     * @return $this
     * @deprecated
     */
    public function setUpdateConfigRequest($var)
    {
        @trigger_error('update_config_request is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\UpdateConfigRequest::class);
        $this->writeOneof(21, $var);

        return $this;
    }

    /**
     * The percent progress of the Operation. Values can range from 0-100. If the
     * value is 100, then the operation is finished.
     *
     * Generated from protobuf field <code>int32 progress_percent = 22;</code>
     * @return int
     */
    public function getProgressPercent()
    {
        return $this->progress_percent;
    }

    /**
     * The percent progress of the Operation. Values can range from 0-100. If the
     * value is 100, then the operation is finished.
     *
     * Generated from protobuf field <code>int32 progress_percent = 22;</code>
     * @param int $var
     * @return $this
     */
    public function setProgressPercent($var)
    {
        GPBUtil::checkInt32($var);
        $this->progress_percent = $var;

        return $this;
    }

    /**
     * Metadata specific to the BatchRecognize method.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
     * @return \Google\Cloud\Speech\V2\BatchRecognizeMetadata|null
     */
    public function getBatchRecognizeMetadata()
    {
        return $this->readOneof(23);
    }

    public function hasBatchRecognizeMetadata()
    {
        return $this->hasOneof(23);
    }

    /**
     * Metadata specific to the BatchRecognize method.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
     * @param \Google\Cloud\Speech\V2\BatchRecognizeMetadata $var
     * @return $this
     */
    public function setBatchRecognizeMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\BatchRecognizeMetadata::class);
        $this->writeOneof(23, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getRequest()
    {
        return $this->whichOneof("request");
    }

    /**
     * @return string
     */
    public function getMetadata()
    {
        return $this->whichOneof("metadata");
    }

}

