<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/speech/v1p1beta1/cloud_speech.proto

namespace Google\Cloud\Speech\V1p1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * `StreamingRecognizeResponse` is the only message returned to the client by
 * `StreamingRecognize`. A series of zero or more `StreamingRecognizeResponse`
 * messages are streamed back to the client. If there is no recognizable
 * audio, and `single_utterance` is set to false, then no messages are streamed
 * back to the client.
 * Here's an example of a series of `StreamingRecognizeResponse`s that might be
 * returned while processing audio:
 * 1. results { alternatives { transcript: "tube" } stability: 0.01 }
 * 2. results { alternatives { transcript: "to be a" } stability: 0.01 }
 * 3. results { alternatives { transcript: "to be" } stability: 0.9 }
 *    results { alternatives { transcript: " or not to be" } stability: 0.01 }
 * 4. results { alternatives { transcript: "to be or not to be"
 *                             confidence: 0.92 }
 *              alternatives { transcript: "to bee or not to bee" }
 *              is_final: true }
 * 5. results { alternatives { transcript: " that's" } stability: 0.01 }
 * 6. results { alternatives { transcript: " that is" } stability: 0.9 }
 *    results { alternatives { transcript: " the question" } stability: 0.01 }
 * 7. results { alternatives { transcript: " that is the question"
 *                             confidence: 0.98 }
 *              alternatives { transcript: " that was the question" }
 *              is_final: true }
 * Notes:
 * - Only two of the above responses #4 and #7 contain final results; they are
 *   indicated by `is_final: true`. Concatenating these together generates the
 *   full transcript: "to be or not to be that is the question".
 * - The others contain interim `results`. #3 and #6 contain two interim
 *   `results`: the first portion has a high stability and is less likely to
 *   change; the second portion has a low stability and is very likely to
 *   change. A UI designer might choose to show only high stability `results`.
 * - The specific `stability` and `confidence` values shown above are only for
 *   illustrative purposes. Actual values may vary.
 * - In each response, only one of these fields will be set:
 *     `error`,
 *     `speech_event_type`, or
 *     one or more (repeated) `results`.
 *
 * Generated from protobuf message <code>google.cloud.speech.v1p1beta1.StreamingRecognizeResponse</code>
 */
class StreamingRecognizeResponse extends \Google\Protobuf\Internal\Message
{
    /**
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 1;</code>
     */
    private $error = null;
    /**
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     *
     * Generated from protobuf field <code>repeated .google.cloud.speech.v1p1beta1.StreamingRecognitionResult results = 2;</code>
     */
    private $results;
    /**
     * Indicates the type of speech event.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v1p1beta1.StreamingRecognizeResponse.SpeechEventType speech_event_type = 4;</code>
     */
    private $speech_event_type = 0;
    /**
     * Time offset between the beginning of the audio and event emission.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration speech_event_time = 8;</code>
     */
    private $speech_event_time = null;
    /**
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration total_billed_time = 5;</code>
     */
    private $total_billed_time = null;
    /**
     * Provides information on adaptation behavior in response
     *
     * Generated from protobuf field <code>.google.cloud.speech.v1p1beta1.SpeechAdaptationInfo speech_adaptation_info = 9;</code>
     */
    private $speech_adaptation_info = null;
    /**
     * The ID associated with the request. This is a unique ID specific only to
     * the given request.
     *
     * Generated from protobuf field <code>int64 request_id = 10;</code>
     */
    private $request_id = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Rpc\Status $error
     *           If set, returns a [google.rpc.Status][google.rpc.Status] message that
     *           specifies the error for the operation.
     *     @type array<\Google\Cloud\Speech\V1p1beta1\StreamingRecognitionResult>|\Google\Protobuf\Internal\RepeatedField $results
     *           This repeated list contains zero or more results that
     *           correspond to consecutive portions of the audio currently being processed.
     *           It contains zero or one `is_final=true` result (the newly settled portion),
     *           followed by zero or more `is_final=false` results (the interim results).
     *     @type int $speech_event_type
     *           Indicates the type of speech event.
     *     @type \Google\Protobuf\Duration $speech_event_time
     *           Time offset between the beginning of the audio and event emission.
     *     @type \Google\Protobuf\Duration $total_billed_time
     *           When available, billed audio seconds for the stream.
     *           Set only if this is the last response in the stream.
     *     @type \Google\Cloud\Speech\V1p1beta1\SpeechAdaptationInfo $speech_adaptation_info
     *           Provides information on adaptation behavior in response
     *     @type int|string $request_id
     *           The ID associated with the request. This is a unique ID specific only to
     *           the given request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Speech\V1P1Beta1\CloudSpeech::initOnce();
        parent::__construct($data);
    }

    /**
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 1;</code>
     * @return \Google\Rpc\Status|null
     */
    public function getError()
    {
        return $this->error;
    }

    public function hasError()
    {
        return isset($this->error);
    }

    public function clearError()
    {
        unset($this->error);
    }

    /**
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 1;</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->error = $var;

        return $this;
    }

    /**
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     *
     * Generated from protobuf field <code>repeated .google.cloud.speech.v1p1beta1.StreamingRecognitionResult results = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResults()
    {
        return $this->results;
    }

    /**
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     *
     * Generated from protobuf field <code>repeated .google.cloud.speech.v1p1beta1.StreamingRecognitionResult results = 2;</code>
     * @param array<\Google\Cloud\Speech\V1p1beta1\StreamingRecognitionResult>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResults($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Speech\V1p1beta1\StreamingRecognitionResult::class);
        $this->results = $arr;

        return $this;
    }

    /**
     * Indicates the type of speech event.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v1p1beta1.StreamingRecognizeResponse.SpeechEventType speech_event_type = 4;</code>
     * @return int
     */
    public function getSpeechEventType()
    {
        return $this->speech_event_type;
    }

    /**
     * Indicates the type of speech event.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v1p1beta1.StreamingRecognizeResponse.SpeechEventType speech_event_type = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setSpeechEventType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Speech\V1p1beta1\StreamingRecognizeResponse\SpeechEventType::class);
        $this->speech_event_type = $var;

        return $this;
    }

    /**
     * Time offset between the beginning of the audio and event emission.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration speech_event_time = 8;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getSpeechEventTime()
    {
        return $this->speech_event_time;
    }

    public function hasSpeechEventTime()
    {
        return isset($this->speech_event_time);
    }

    public function clearSpeechEventTime()
    {
        unset($this->speech_event_time);
    }

    /**
     * Time offset between the beginning of the audio and event emission.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration speech_event_time = 8;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setSpeechEventTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->speech_event_time = $var;

        return $this;
    }

    /**
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration total_billed_time = 5;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTotalBilledTime()
    {
        return $this->total_billed_time;
    }

    public function hasTotalBilledTime()
    {
        return isset($this->total_billed_time);
    }

    public function clearTotalBilledTime()
    {
        unset($this->total_billed_time);
    }

    /**
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration total_billed_time = 5;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTotalBilledTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->total_billed_time = $var;

        return $this;
    }

    /**
     * Provides information on adaptation behavior in response
     *
     * Generated from protobuf field <code>.google.cloud.speech.v1p1beta1.SpeechAdaptationInfo speech_adaptation_info = 9;</code>
     * @return \Google\Cloud\Speech\V1p1beta1\SpeechAdaptationInfo|null
     */
    public function getSpeechAdaptationInfo()
    {
        return $this->speech_adaptation_info;
    }

    public function hasSpeechAdaptationInfo()
    {
        return isset($this->speech_adaptation_info);
    }

    public function clearSpeechAdaptationInfo()
    {
        unset($this->speech_adaptation_info);
    }

    /**
     * Provides information on adaptation behavior in response
     *
     * Generated from protobuf field <code>.google.cloud.speech.v1p1beta1.SpeechAdaptationInfo speech_adaptation_info = 9;</code>
     * @param \Google\Cloud\Speech\V1p1beta1\SpeechAdaptationInfo $var
     * @return $this
     */
    public function setSpeechAdaptationInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V1p1beta1\SpeechAdaptationInfo::class);
        $this->speech_adaptation_info = $var;

        return $this;
    }

    /**
     * The ID associated with the request. This is a unique ID specific only to
     * the given request.
     *
     * Generated from protobuf field <code>int64 request_id = 10;</code>
     * @return int|string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * The ID associated with the request. This is a unique ID specific only to
     * the given request.
     *
     * Generated from protobuf field <code>int64 request_id = 10;</code>
     * @param int|string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkInt64($var);
        $this->request_id = $var;

        return $this;
    }

}

