<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: grafeas/v1/provenance.proto

namespace Grafeas\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Source describes the location of the source used for the build.
 *
 * Generated from protobuf message <code>grafeas.v1.Source</code>
 */
class Source extends \Google\Protobuf\Internal\Message
{
    /**
     * If provided, the input binary artifacts for the build came from this
     * location.
     *
     * Generated from protobuf field <code>string artifact_storage_source_uri = 1;</code>
     */
    private $artifact_storage_source_uri = '';
    /**
     * Hash(es) of the build source, which can be used to verify that the original
     * source integrity was maintained in the build.
     * The keys to this map are file paths used as build source and the values
     * contain the hash values for those files.
     * If the build source came in a single package such as a gzipped tarfile
     * (.tar.gz), the FileHash will be for the single path to that file.
     *
     * Generated from protobuf field <code>map<string, .grafeas.v1.FileHashes> file_hashes = 2;</code>
     */
    private $file_hashes;
    /**
     * If provided, the source code used for the build came from this location.
     *
     * Generated from protobuf field <code>.grafeas.v1.SourceContext context = 3;</code>
     */
    private $context = null;
    /**
     * If provided, some of the source code used for the build may be found in
     * these locations, in the case where the source repository had multiple
     * remotes or submodules. This list will not include the context specified in
     * the context field.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.SourceContext additional_contexts = 4;</code>
     */
    private $additional_contexts;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $artifact_storage_source_uri
     *           If provided, the input binary artifacts for the build came from this
     *           location.
     *     @type array|\Google\Protobuf\Internal\MapField $file_hashes
     *           Hash(es) of the build source, which can be used to verify that the original
     *           source integrity was maintained in the build.
     *           The keys to this map are file paths used as build source and the values
     *           contain the hash values for those files.
     *           If the build source came in a single package such as a gzipped tarfile
     *           (.tar.gz), the FileHash will be for the single path to that file.
     *     @type \Grafeas\V1\SourceContext $context
     *           If provided, the source code used for the build came from this location.
     *     @type array<\Grafeas\V1\SourceContext>|\Google\Protobuf\Internal\RepeatedField $additional_contexts
     *           If provided, some of the source code used for the build may be found in
     *           these locations, in the case where the source repository had multiple
     *           remotes or submodules. This list will not include the context specified in
     *           the context field.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Grafeas\V1\Provenance::initOnce();
        parent::__construct($data);
    }

    /**
     * If provided, the input binary artifacts for the build came from this
     * location.
     *
     * Generated from protobuf field <code>string artifact_storage_source_uri = 1;</code>
     * @return string
     */
    public function getArtifactStorageSourceUri()
    {
        return $this->artifact_storage_source_uri;
    }

    /**
     * If provided, the input binary artifacts for the build came from this
     * location.
     *
     * Generated from protobuf field <code>string artifact_storage_source_uri = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setArtifactStorageSourceUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->artifact_storage_source_uri = $var;

        return $this;
    }

    /**
     * Hash(es) of the build source, which can be used to verify that the original
     * source integrity was maintained in the build.
     * The keys to this map are file paths used as build source and the values
     * contain the hash values for those files.
     * If the build source came in a single package such as a gzipped tarfile
     * (.tar.gz), the FileHash will be for the single path to that file.
     *
     * Generated from protobuf field <code>map<string, .grafeas.v1.FileHashes> file_hashes = 2;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getFileHashes()
    {
        return $this->file_hashes;
    }

    /**
     * Hash(es) of the build source, which can be used to verify that the original
     * source integrity was maintained in the build.
     * The keys to this map are file paths used as build source and the values
     * contain the hash values for those files.
     * If the build source came in a single package such as a gzipped tarfile
     * (.tar.gz), the FileHash will be for the single path to that file.
     *
     * Generated from protobuf field <code>map<string, .grafeas.v1.FileHashes> file_hashes = 2;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setFileHashes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Grafeas\V1\FileHashes::class);
        $this->file_hashes = $arr;

        return $this;
    }

    /**
     * If provided, the source code used for the build came from this location.
     *
     * Generated from protobuf field <code>.grafeas.v1.SourceContext context = 3;</code>
     * @return \Grafeas\V1\SourceContext|null
     */
    public function getContext()
    {
        return $this->context;
    }

    public function hasContext()
    {
        return isset($this->context);
    }

    public function clearContext()
    {
        unset($this->context);
    }

    /**
     * If provided, the source code used for the build came from this location.
     *
     * Generated from protobuf field <code>.grafeas.v1.SourceContext context = 3;</code>
     * @param \Grafeas\V1\SourceContext $var
     * @return $this
     */
    public function setContext($var)
    {
        GPBUtil::checkMessage($var, \Grafeas\V1\SourceContext::class);
        $this->context = $var;

        return $this;
    }

    /**
     * If provided, some of the source code used for the build may be found in
     * these locations, in the case where the source repository had multiple
     * remotes or submodules. This list will not include the context specified in
     * the context field.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.SourceContext additional_contexts = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdditionalContexts()
    {
        return $this->additional_contexts;
    }

    /**
     * If provided, some of the source code used for the build may be found in
     * these locations, in the case where the source repository had multiple
     * remotes or submodules. This list will not include the context specified in
     * the context field.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.SourceContext additional_contexts = 4;</code>
     * @param array<\Grafeas\V1\SourceContext>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdditionalContexts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Grafeas\V1\SourceContext::class);
        $this->additional_contexts = $arr;

        return $this;
    }

}

