<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: grafeas/v1/common.proto

namespace Grafeas\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Verifiers (e.g. Kritis implementations) MUST verify signatures
 * with respect to the trust anchors defined in policy (e.g. a Kritis policy).
 * Typically this means that the verifier has been configured with a map from
 * `public_key_id` to public key material (and any required parameters, e.g.
 * signing algorithm).
 * In particular, verification implementations MUST NOT treat the signature
 * `public_key_id` as anything more than a key lookup hint. The `public_key_id`
 * DOES NOT validate or authenticate a public key; it only provides a mechanism
 * for quickly selecting a public key ALREADY CONFIGURED on the verifier through
 * a trusted channel. Verification implementations MUST reject signatures in any
 * of the following circumstances:
 *   * The `public_key_id` is not recognized by the verifier.
 *   * The public key that `public_key_id` refers to does not verify the
 *     signature with respect to the payload.
 * The `signature` contents SHOULD NOT be "attached" (where the payload is
 * included with the serialized `signature` bytes). Verifiers MUST ignore any
 * "attached" payload and only verify signatures with respect to explicitly
 * provided payload (e.g. a `payload` field on the proto message that holds
 * this Signature, or the canonical serialization of the proto message that
 * holds this signature).
 *
 * Generated from protobuf message <code>grafeas.v1.Signature</code>
 */
class Signature extends \Google\Protobuf\Internal\Message
{
    /**
     * The content of the signature, an opaque bytestring.
     * The payload that this signature verifies MUST be unambiguously provided
     * with the Signature during verification. A wrapper message might provide
     * the payload explicitly. Alternatively, a message might have a canonical
     * serialization that can always be unambiguously computed to derive the
     * payload.
     *
     * Generated from protobuf field <code>bytes signature = 1;</code>
     */
    private $signature = '';
    /**
     * The identifier for the public key that verifies this signature.
     *   * The `public_key_id` is required.
     *   * The `public_key_id` SHOULD be an RFC3986 conformant URI.
     *   * When possible, the `public_key_id` SHOULD be an immutable reference,
     *     such as a cryptographic digest.
     * Examples of valid `public_key_id`s:
     * OpenPGP V4 public key fingerprint:
     *   * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA"
     * See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more
     * details on this scheme.
     * RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER
     * serialization):
     *   * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU"
     *   * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
     *
     * Generated from protobuf field <code>string public_key_id = 2;</code>
     */
    private $public_key_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $signature
     *           The content of the signature, an opaque bytestring.
     *           The payload that this signature verifies MUST be unambiguously provided
     *           with the Signature during verification. A wrapper message might provide
     *           the payload explicitly. Alternatively, a message might have a canonical
     *           serialization that can always be unambiguously computed to derive the
     *           payload.
     *     @type string $public_key_id
     *           The identifier for the public key that verifies this signature.
     *             * The `public_key_id` is required.
     *             * The `public_key_id` SHOULD be an RFC3986 conformant URI.
     *             * When possible, the `public_key_id` SHOULD be an immutable reference,
     *               such as a cryptographic digest.
     *           Examples of valid `public_key_id`s:
     *           OpenPGP V4 public key fingerprint:
     *             * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA"
     *           See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more
     *           details on this scheme.
     *           RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER
     *           serialization):
     *             * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU"
     *             * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Grafeas\V1\Common::initOnce();
        parent::__construct($data);
    }

    /**
     * The content of the signature, an opaque bytestring.
     * The payload that this signature verifies MUST be unambiguously provided
     * with the Signature during verification. A wrapper message might provide
     * the payload explicitly. Alternatively, a message might have a canonical
     * serialization that can always be unambiguously computed to derive the
     * payload.
     *
     * Generated from protobuf field <code>bytes signature = 1;</code>
     * @return string
     */
    public function getSignature()
    {
        return $this->signature;
    }

    /**
     * The content of the signature, an opaque bytestring.
     * The payload that this signature verifies MUST be unambiguously provided
     * with the Signature during verification. A wrapper message might provide
     * the payload explicitly. Alternatively, a message might have a canonical
     * serialization that can always be unambiguously computed to derive the
     * payload.
     *
     * Generated from protobuf field <code>bytes signature = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setSignature($var)
    {
        GPBUtil::checkString($var, False);
        $this->signature = $var;

        return $this;
    }

    /**
     * The identifier for the public key that verifies this signature.
     *   * The `public_key_id` is required.
     *   * The `public_key_id` SHOULD be an RFC3986 conformant URI.
     *   * When possible, the `public_key_id` SHOULD be an immutable reference,
     *     such as a cryptographic digest.
     * Examples of valid `public_key_id`s:
     * OpenPGP V4 public key fingerprint:
     *   * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA"
     * See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more
     * details on this scheme.
     * RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER
     * serialization):
     *   * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU"
     *   * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
     *
     * Generated from protobuf field <code>string public_key_id = 2;</code>
     * @return string
     */
    public function getPublicKeyId()
    {
        return $this->public_key_id;
    }

    /**
     * The identifier for the public key that verifies this signature.
     *   * The `public_key_id` is required.
     *   * The `public_key_id` SHOULD be an RFC3986 conformant URI.
     *   * When possible, the `public_key_id` SHOULD be an immutable reference,
     *     such as a cryptographic digest.
     * Examples of valid `public_key_id`s:
     * OpenPGP V4 public key fingerprint:
     *   * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA"
     * See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more
     * details on this scheme.
     * RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER
     * serialization):
     *   * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU"
     *   * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
     *
     * Generated from protobuf field <code>string public_key_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setPublicKeyId($var)
    {
        GPBUtil::checkString($var, True);
        $this->public_key_id = $var;

        return $this;
    }

}

