<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/dataflow/v1beta3/jobs.proto

namespace Google\Cloud\Dataflow\V1beta3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Defines a particular step within a Cloud Dataflow job.
 * A job consists of multiple steps, each of which performs some
 * specific operation as part of the overall job.  Data is typically
 * passed from one step to another as part of the job.
 * Here's an example of a sequence of steps which together implement a
 * Map-Reduce job:
 *   * Read a collection of data from some source, parsing the
 *     collection's elements.
 *   * Validate the elements.
 *   * Apply a user-defined function to map each element to some value
 *     and extract an element-specific key value.
 *   * Group elements with the same key into a single element with
 *     that key, transforming a multiply-keyed collection into a
 *     uniquely-keyed collection.
 *   * Write the elements out to some data sink.
 * Note that the Cloud Dataflow service may be used to run many different
 * types of jobs, not just Map-Reduce.
 *
 * Generated from protobuf message <code>google.dataflow.v1beta3.Step</code>
 */
class Step extends \Google\Protobuf\Internal\Message
{
    /**
     * The kind of step in the Cloud Dataflow job.
     *
     * Generated from protobuf field <code>string kind = 1;</code>
     */
    private $kind = '';
    /**
     * The name that identifies the step. This must be unique for each
     * step with respect to all other steps in the Cloud Dataflow job.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     */
    private $name = '';
    /**
     * Named properties associated with the step. Each kind of
     * predefined step has its own required set of properties.
     * Must be provided on Create.  Only retrieved with JOB_VIEW_ALL.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct properties = 3;</code>
     */
    private $properties = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $kind
     *           The kind of step in the Cloud Dataflow job.
     *     @type string $name
     *           The name that identifies the step. This must be unique for each
     *           step with respect to all other steps in the Cloud Dataflow job.
     *     @type \Google\Protobuf\Struct $properties
     *           Named properties associated with the step. Each kind of
     *           predefined step has its own required set of properties.
     *           Must be provided on Create.  Only retrieved with JOB_VIEW_ALL.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Dataflow\V1Beta3\Jobs::initOnce();
        parent::__construct($data);
    }

    /**
     * The kind of step in the Cloud Dataflow job.
     *
     * Generated from protobuf field <code>string kind = 1;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * The kind of step in the Cloud Dataflow job.
     *
     * Generated from protobuf field <code>string kind = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * The name that identifies the step. This must be unique for each
     * step with respect to all other steps in the Cloud Dataflow job.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name that identifies the step. This must be unique for each
     * step with respect to all other steps in the Cloud Dataflow job.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Named properties associated with the step. Each kind of
     * predefined step has its own required set of properties.
     * Must be provided on Create.  Only retrieved with JOB_VIEW_ALL.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct properties = 3;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getProperties()
    {
        return $this->properties;
    }

    public function hasProperties()
    {
        return isset($this->properties);
    }

    public function clearProperties()
    {
        unset($this->properties);
    }

    /**
     * Named properties associated with the step. Each kind of
     * predefined step has its own required set of properties.
     * Must be provided on Create.  Only retrieved with JOB_VIEW_ALL.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct properties = 3;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setProperties($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->properties = $var;

        return $this;
    }

}

