<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * NetworkConfig reports the relative names of network & subnetwork.
 *
 * Generated from protobuf message <code>google.container.v1.NetworkConfig</code>
 */
class NetworkConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The relative name of the Google Compute Engine
     * [network][google.container.v1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. Example:
     * projects/my-project/global/networks/my-network
     *
     * Generated from protobuf field <code>string network = 1;</code>
     */
    private $network = '';
    /**
     * Output only. The relative name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
     * cluster is connected. Example:
     * projects/my-project/regions/us-central1/subnetworks/my-subnet
     *
     * Generated from protobuf field <code>string subnetwork = 2;</code>
     */
    private $subnetwork = '';
    /**
     * Whether Intra-node visibility is enabled for this cluster.
     * This makes same node pod to pod traffic visible for VPC network.
     *
     * Generated from protobuf field <code>bool enable_intra_node_visibility = 5;</code>
     */
    private $enable_intra_node_visibility = false;
    /**
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     *
     * Generated from protobuf field <code>.google.container.v1.DefaultSnatStatus default_snat_status = 7;</code>
     */
    private $default_snat_status = null;
    /**
     * Whether L4ILB Subsetting is enabled for this cluster.
     *
     * Generated from protobuf field <code>bool enable_l4ilb_subsetting = 10;</code>
     */
    private $enable_l4ilb_subsetting = false;
    /**
     * The desired datapath provider for this cluster. By default, uses the
     * IPTables-based kube-proxy implementation.
     *
     * Generated from protobuf field <code>.google.container.v1.DatapathProvider datapath_provider = 11;</code>
     */
    private $datapath_provider = 0;
    /**
     * The desired state of IPv6 connectivity to Google Services.
     * By default, no private IPv6 access to or from Google Services (all access
     * will be via IPv4)
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateIPv6GoogleAccess private_ipv6_google_access = 12;</code>
     */
    private $private_ipv6_google_access = 0;
    /**
     * DNSConfig contains clusterDNS config for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DNSConfig dns_config = 13;</code>
     */
    private $dns_config = null;
    /**
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     *
     * Generated from protobuf field <code>.google.container.v1.ServiceExternalIPsConfig service_external_ips_config = 15;</code>
     */
    private $service_external_ips_config = null;
    /**
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.GatewayAPIConfig gateway_api_config = 16;</code>
     */
    private $gateway_api_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $network
     *           Output only. The relative name of the Google Compute Engine
     *           [network][google.container.v1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     *           to which the cluster is connected. Example:
     *           projects/my-project/global/networks/my-network
     *     @type string $subnetwork
     *           Output only. The relative name of the Google Compute Engine
     *           [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
     *           cluster is connected. Example:
     *           projects/my-project/regions/us-central1/subnetworks/my-subnet
     *     @type bool $enable_intra_node_visibility
     *           Whether Intra-node visibility is enabled for this cluster.
     *           This makes same node pod to pod traffic visible for VPC network.
     *     @type \Google\Cloud\Container\V1\DefaultSnatStatus $default_snat_status
     *           Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     *           will be disabled when default_snat_status is disabled. When disabled is set
     *           to false, default IP masquerade rules will be applied to the nodes to
     *           prevent sNAT on cluster internal traffic.
     *     @type bool $enable_l4ilb_subsetting
     *           Whether L4ILB Subsetting is enabled for this cluster.
     *     @type int $datapath_provider
     *           The desired datapath provider for this cluster. By default, uses the
     *           IPTables-based kube-proxy implementation.
     *     @type int $private_ipv6_google_access
     *           The desired state of IPv6 connectivity to Google Services.
     *           By default, no private IPv6 access to or from Google Services (all access
     *           will be via IPv4)
     *     @type \Google\Cloud\Container\V1\DNSConfig $dns_config
     *           DNSConfig contains clusterDNS config for this cluster.
     *     @type \Google\Cloud\Container\V1\ServiceExternalIPsConfig $service_external_ips_config
     *           ServiceExternalIPsConfig specifies if services with externalIPs field are
     *           blocked or not.
     *     @type \Google\Cloud\Container\V1\GatewayAPIConfig $gateway_api_config
     *           GatewayAPIConfig contains the desired config of Gateway API on this
     *           cluster.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The relative name of the Google Compute Engine
     * [network][google.container.v1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. Example:
     * projects/my-project/global/networks/my-network
     *
     * Generated from protobuf field <code>string network = 1;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * Output only. The relative name of the Google Compute Engine
     * [network][google.container.v1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. Example:
     * projects/my-project/global/networks/my-network
     *
     * Generated from protobuf field <code>string network = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Output only. The relative name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
     * cluster is connected. Example:
     * projects/my-project/regions/us-central1/subnetworks/my-subnet
     *
     * Generated from protobuf field <code>string subnetwork = 2;</code>
     * @return string
     */
    public function getSubnetwork()
    {
        return $this->subnetwork;
    }

    /**
     * Output only. The relative name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
     * cluster is connected. Example:
     * projects/my-project/regions/us-central1/subnetworks/my-subnet
     *
     * Generated from protobuf field <code>string subnetwork = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setSubnetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->subnetwork = $var;

        return $this;
    }

    /**
     * Whether Intra-node visibility is enabled for this cluster.
     * This makes same node pod to pod traffic visible for VPC network.
     *
     * Generated from protobuf field <code>bool enable_intra_node_visibility = 5;</code>
     * @return bool
     */
    public function getEnableIntraNodeVisibility()
    {
        return $this->enable_intra_node_visibility;
    }

    /**
     * Whether Intra-node visibility is enabled for this cluster.
     * This makes same node pod to pod traffic visible for VPC network.
     *
     * Generated from protobuf field <code>bool enable_intra_node_visibility = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableIntraNodeVisibility($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_intra_node_visibility = $var;

        return $this;
    }

    /**
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     *
     * Generated from protobuf field <code>.google.container.v1.DefaultSnatStatus default_snat_status = 7;</code>
     * @return \Google\Cloud\Container\V1\DefaultSnatStatus|null
     */
    public function getDefaultSnatStatus()
    {
        return $this->default_snat_status;
    }

    public function hasDefaultSnatStatus()
    {
        return isset($this->default_snat_status);
    }

    public function clearDefaultSnatStatus()
    {
        unset($this->default_snat_status);
    }

    /**
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     *
     * Generated from protobuf field <code>.google.container.v1.DefaultSnatStatus default_snat_status = 7;</code>
     * @param \Google\Cloud\Container\V1\DefaultSnatStatus $var
     * @return $this
     */
    public function setDefaultSnatStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\DefaultSnatStatus::class);
        $this->default_snat_status = $var;

        return $this;
    }

    /**
     * Whether L4ILB Subsetting is enabled for this cluster.
     *
     * Generated from protobuf field <code>bool enable_l4ilb_subsetting = 10;</code>
     * @return bool
     */
    public function getEnableL4IlbSubsetting()
    {
        return $this->enable_l4ilb_subsetting;
    }

    /**
     * Whether L4ILB Subsetting is enabled for this cluster.
     *
     * Generated from protobuf field <code>bool enable_l4ilb_subsetting = 10;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableL4IlbSubsetting($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_l4ilb_subsetting = $var;

        return $this;
    }

    /**
     * The desired datapath provider for this cluster. By default, uses the
     * IPTables-based kube-proxy implementation.
     *
     * Generated from protobuf field <code>.google.container.v1.DatapathProvider datapath_provider = 11;</code>
     * @return int
     */
    public function getDatapathProvider()
    {
        return $this->datapath_provider;
    }

    /**
     * The desired datapath provider for this cluster. By default, uses the
     * IPTables-based kube-proxy implementation.
     *
     * Generated from protobuf field <code>.google.container.v1.DatapathProvider datapath_provider = 11;</code>
     * @param int $var
     * @return $this
     */
    public function setDatapathProvider($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Container\V1\DatapathProvider::class);
        $this->datapath_provider = $var;

        return $this;
    }

    /**
     * The desired state of IPv6 connectivity to Google Services.
     * By default, no private IPv6 access to or from Google Services (all access
     * will be via IPv4)
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateIPv6GoogleAccess private_ipv6_google_access = 12;</code>
     * @return int
     */
    public function getPrivateIpv6GoogleAccess()
    {
        return $this->private_ipv6_google_access;
    }

    /**
     * The desired state of IPv6 connectivity to Google Services.
     * By default, no private IPv6 access to or from Google Services (all access
     * will be via IPv4)
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateIPv6GoogleAccess private_ipv6_google_access = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setPrivateIpv6GoogleAccess($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Container\V1\PrivateIPv6GoogleAccess::class);
        $this->private_ipv6_google_access = $var;

        return $this;
    }

    /**
     * DNSConfig contains clusterDNS config for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DNSConfig dns_config = 13;</code>
     * @return \Google\Cloud\Container\V1\DNSConfig|null
     */
    public function getDnsConfig()
    {
        return $this->dns_config;
    }

    public function hasDnsConfig()
    {
        return isset($this->dns_config);
    }

    public function clearDnsConfig()
    {
        unset($this->dns_config);
    }

    /**
     * DNSConfig contains clusterDNS config for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DNSConfig dns_config = 13;</code>
     * @param \Google\Cloud\Container\V1\DNSConfig $var
     * @return $this
     */
    public function setDnsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\DNSConfig::class);
        $this->dns_config = $var;

        return $this;
    }

    /**
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     *
     * Generated from protobuf field <code>.google.container.v1.ServiceExternalIPsConfig service_external_ips_config = 15;</code>
     * @return \Google\Cloud\Container\V1\ServiceExternalIPsConfig|null
     */
    public function getServiceExternalIpsConfig()
    {
        return $this->service_external_ips_config;
    }

    public function hasServiceExternalIpsConfig()
    {
        return isset($this->service_external_ips_config);
    }

    public function clearServiceExternalIpsConfig()
    {
        unset($this->service_external_ips_config);
    }

    /**
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     *
     * Generated from protobuf field <code>.google.container.v1.ServiceExternalIPsConfig service_external_ips_config = 15;</code>
     * @param \Google\Cloud\Container\V1\ServiceExternalIPsConfig $var
     * @return $this
     */
    public function setServiceExternalIpsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ServiceExternalIPsConfig::class);
        $this->service_external_ips_config = $var;

        return $this;
    }

    /**
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.GatewayAPIConfig gateway_api_config = 16;</code>
     * @return \Google\Cloud\Container\V1\GatewayAPIConfig|null
     */
    public function getGatewayApiConfig()
    {
        return $this->gateway_api_config;
    }

    public function hasGatewayApiConfig()
    {
        return isset($this->gateway_api_config);
    }

    public function clearGatewayApiConfig()
    {
        unset($this->gateway_api_config);
    }

    /**
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.GatewayAPIConfig gateway_api_config = 16;</code>
     * @param \Google\Cloud\Container\V1\GatewayAPIConfig $var
     * @return $this
     */
    public function setGatewayApiConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\GatewayAPIConfig::class);
        $this->gateway_api_config = $var;

        return $this;
    }

}

