<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/storage/v1/storage.proto

namespace Google\Cloud\BigQuery\Storage\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Response message for `AppendRows`.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.storage.v1.AppendRowsResponse</code>
 */
class AppendRowsResponse extends \Google\Protobuf\Internal\Message
{
    /**
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.TableSchema updated_schema = 3;</code>
     */
    private $updated_schema = null;
    /**
     * If a request failed due to corrupted rows, no rows in the batch will be
     * appended. The API will return row level error info, so that the caller can
     * remove the bad rows and retry the request.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.storage.v1.RowError row_errors = 4;</code>
     */
    private $row_errors;
    /**
     * The target of the append operation. Matches the write_stream in the
     * corresponding request.
     *
     * Generated from protobuf field <code>string write_stream = 5;</code>
     */
    private $write_stream = '';
    protected $response;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\BigQuery\Storage\V1\AppendRowsResponse\AppendResult $append_result
     *           Result if the append is successful.
     *     @type \Google\Rpc\Status $error
     *           Error returned when problems were encountered.  If present,
     *           it indicates rows were not accepted into the system.
     *           Users can retry or continue with other append requests within the
     *           same connection.
     *           Additional information about error signalling:
     *           ALREADY_EXISTS: Happens when an append specified an offset, and the
     *           backend already has received data at this offset.  Typically encountered
     *           in retry scenarios, and can be ignored.
     *           OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     *           the current end of the stream.
     *           INVALID_ARGUMENT: Indicates a malformed request or data.
     *           ABORTED: Request processing is aborted because of prior failures.  The
     *           request can be retried if previous failure is addressed.
     *           INTERNAL: Indicates server side error(s) that can be retried.
     *     @type \Google\Cloud\BigQuery\Storage\V1\TableSchema $updated_schema
     *           If backend detects a schema update, pass it to user so that user can
     *           use it to input new type of message. It will be empty when no schema
     *           updates have occurred.
     *     @type array<\Google\Cloud\BigQuery\Storage\V1\RowError>|\Google\Protobuf\Internal\RepeatedField $row_errors
     *           If a request failed due to corrupted rows, no rows in the batch will be
     *           appended. The API will return row level error info, so that the caller can
     *           remove the bad rows and retry the request.
     *     @type string $write_stream
     *           The target of the append operation. Matches the write_stream in the
     *           corresponding request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Storage\V1\Storage::initOnce();
        parent::__construct($data);
    }

    /**
     * Result if the append is successful.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.AppendRowsResponse.AppendResult append_result = 1;</code>
     * @return \Google\Cloud\BigQuery\Storage\V1\AppendRowsResponse\AppendResult|null
     */
    public function getAppendResult()
    {
        return $this->readOneof(1);
    }

    public function hasAppendResult()
    {
        return $this->hasOneof(1);
    }

    /**
     * Result if the append is successful.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.AppendRowsResponse.AppendResult append_result = 1;</code>
     * @param \Google\Cloud\BigQuery\Storage\V1\AppendRowsResponse\AppendResult $var
     * @return $this
     */
    public function setAppendResult($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Storage\V1\AppendRowsResponse\AppendResult::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Error returned when problems were encountered.  If present,
     * it indicates rows were not accepted into the system.
     * Users can retry or continue with other append requests within the
     * same connection.
     * Additional information about error signalling:
     * ALREADY_EXISTS: Happens when an append specified an offset, and the
     * backend already has received data at this offset.  Typically encountered
     * in retry scenarios, and can be ignored.
     * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     * the current end of the stream.
     * INVALID_ARGUMENT: Indicates a malformed request or data.
     * ABORTED: Request processing is aborted because of prior failures.  The
     * request can be retried if previous failure is addressed.
     * INTERNAL: Indicates server side error(s) that can be retried.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 2;</code>
     * @return \Google\Rpc\Status|null
     */
    public function getError()
    {
        return $this->readOneof(2);
    }

    public function hasError()
    {
        return $this->hasOneof(2);
    }

    /**
     * Error returned when problems were encountered.  If present,
     * it indicates rows were not accepted into the system.
     * Users can retry or continue with other append requests within the
     * same connection.
     * Additional information about error signalling:
     * ALREADY_EXISTS: Happens when an append specified an offset, and the
     * backend already has received data at this offset.  Typically encountered
     * in retry scenarios, and can be ignored.
     * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     * the current end of the stream.
     * INVALID_ARGUMENT: Indicates a malformed request or data.
     * ABORTED: Request processing is aborted because of prior failures.  The
     * request can be retried if previous failure is addressed.
     * INTERNAL: Indicates server side error(s) that can be retried.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 2;</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.TableSchema updated_schema = 3;</code>
     * @return \Google\Cloud\BigQuery\Storage\V1\TableSchema|null
     */
    public function getUpdatedSchema()
    {
        return $this->updated_schema;
    }

    public function hasUpdatedSchema()
    {
        return isset($this->updated_schema);
    }

    public function clearUpdatedSchema()
    {
        unset($this->updated_schema);
    }

    /**
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.TableSchema updated_schema = 3;</code>
     * @param \Google\Cloud\BigQuery\Storage\V1\TableSchema $var
     * @return $this
     */
    public function setUpdatedSchema($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Storage\V1\TableSchema::class);
        $this->updated_schema = $var;

        return $this;
    }

    /**
     * If a request failed due to corrupted rows, no rows in the batch will be
     * appended. The API will return row level error info, so that the caller can
     * remove the bad rows and retry the request.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.storage.v1.RowError row_errors = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRowErrors()
    {
        return $this->row_errors;
    }

    /**
     * If a request failed due to corrupted rows, no rows in the batch will be
     * appended. The API will return row level error info, so that the caller can
     * remove the bad rows and retry the request.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.storage.v1.RowError row_errors = 4;</code>
     * @param array<\Google\Cloud\BigQuery\Storage\V1\RowError>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRowErrors($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BigQuery\Storage\V1\RowError::class);
        $this->row_errors = $arr;

        return $this;
    }

    /**
     * The target of the append operation. Matches the write_stream in the
     * corresponding request.
     *
     * Generated from protobuf field <code>string write_stream = 5;</code>
     * @return string
     */
    public function getWriteStream()
    {
        return $this->write_stream;
    }

    /**
     * The target of the append operation. Matches the write_stream in the
     * corresponding request.
     *
     * Generated from protobuf field <code>string write_stream = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setWriteStream($var)
    {
        GPBUtil::checkString($var, True);
        $this->write_stream = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getResponse()
    {
        return $this->whichOneof("response");
    }

}

