<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/connection/v1/connection.proto

namespace Google\Cloud\BigQuery\Connection\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Connection properties specific to Cloud Spanner.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.connection.v1.CloudSpannerProperties</code>
 */
class CloudSpannerProperties extends \Google\Protobuf\Internal\Message
{
    /**
     * Cloud Spanner database in the form `project/instance/database'
     *
     * Generated from protobuf field <code>string database = 1;</code>
     */
    private $database = '';
    /**
     * If parallelism should be used when reading from Cloud Spanner
     *
     * Generated from protobuf field <code>bool use_parallelism = 2;</code>
     */
    private $use_parallelism = false;
    /**
     * If the serverless analytics service should be used to read data from Cloud
     * Spanner.
     * Note: `use_parallelism` must be set when using serverless analytics.
     *
     * Generated from protobuf field <code>bool use_serverless_analytics = 3;</code>
     */
    private $use_serverless_analytics = false;
    /**
     * Optional. Cloud Spanner database role for fine-grained access control.
     * A database role is a collection of fine-grained access privileges. Example:
     * Admin predefines roles that provides user a set of permissions (SELECT,
     * INSERT, ..). The user can then specify a predefined role on a connection to
     * execute their Cloud Spanner query. The role is passthrough here. If the
     * user is not authorized to use the specified role, they get an error. This
     * validation happens on Cloud Spanner.
     * See https://cloud.google.com/spanner/docs/fgac-about for more details.
     * REQUIRES: database role name must start with uppercase/lowercase letter
     * and only contain uppercase/lowercase letters, numbers, and underscores.
     *
     * Generated from protobuf field <code>string database_role = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $database_role = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $database
     *           Cloud Spanner database in the form `project/instance/database'
     *     @type bool $use_parallelism
     *           If parallelism should be used when reading from Cloud Spanner
     *     @type bool $use_serverless_analytics
     *           If the serverless analytics service should be used to read data from Cloud
     *           Spanner.
     *           Note: `use_parallelism` must be set when using serverless analytics.
     *     @type string $database_role
     *           Optional. Cloud Spanner database role for fine-grained access control.
     *           A database role is a collection of fine-grained access privileges. Example:
     *           Admin predefines roles that provides user a set of permissions (SELECT,
     *           INSERT, ..). The user can then specify a predefined role on a connection to
     *           execute their Cloud Spanner query. The role is passthrough here. If the
     *           user is not authorized to use the specified role, they get an error. This
     *           validation happens on Cloud Spanner.
     *           See https://cloud.google.com/spanner/docs/fgac-about for more details.
     *           REQUIRES: database role name must start with uppercase/lowercase letter
     *           and only contain uppercase/lowercase letters, numbers, and underscores.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Connection\V1\Connection::initOnce();
        parent::__construct($data);
    }

    /**
     * Cloud Spanner database in the form `project/instance/database'
     *
     * Generated from protobuf field <code>string database = 1;</code>
     * @return string
     */
    public function getDatabase()
    {
        return $this->database;
    }

    /**
     * Cloud Spanner database in the form `project/instance/database'
     *
     * Generated from protobuf field <code>string database = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkString($var, True);
        $this->database = $var;

        return $this;
    }

    /**
     * If parallelism should be used when reading from Cloud Spanner
     *
     * Generated from protobuf field <code>bool use_parallelism = 2;</code>
     * @return bool
     */
    public function getUseParallelism()
    {
        return $this->use_parallelism;
    }

    /**
     * If parallelism should be used when reading from Cloud Spanner
     *
     * Generated from protobuf field <code>bool use_parallelism = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseParallelism($var)
    {
        GPBUtil::checkBool($var);
        $this->use_parallelism = $var;

        return $this;
    }

    /**
     * If the serverless analytics service should be used to read data from Cloud
     * Spanner.
     * Note: `use_parallelism` must be set when using serverless analytics.
     *
     * Generated from protobuf field <code>bool use_serverless_analytics = 3;</code>
     * @return bool
     */
    public function getUseServerlessAnalytics()
    {
        return $this->use_serverless_analytics;
    }

    /**
     * If the serverless analytics service should be used to read data from Cloud
     * Spanner.
     * Note: `use_parallelism` must be set when using serverless analytics.
     *
     * Generated from protobuf field <code>bool use_serverless_analytics = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseServerlessAnalytics($var)
    {
        GPBUtil::checkBool($var);
        $this->use_serverless_analytics = $var;

        return $this;
    }

    /**
     * Optional. Cloud Spanner database role for fine-grained access control.
     * A database role is a collection of fine-grained access privileges. Example:
     * Admin predefines roles that provides user a set of permissions (SELECT,
     * INSERT, ..). The user can then specify a predefined role on a connection to
     * execute their Cloud Spanner query. The role is passthrough here. If the
     * user is not authorized to use the specified role, they get an error. This
     * validation happens on Cloud Spanner.
     * See https://cloud.google.com/spanner/docs/fgac-about for more details.
     * REQUIRES: database role name must start with uppercase/lowercase letter
     * and only contain uppercase/lowercase letters, numbers, and underscores.
     *
     * Generated from protobuf field <code>string database_role = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDatabaseRole()
    {
        return $this->database_role;
    }

    /**
     * Optional. Cloud Spanner database role for fine-grained access control.
     * A database role is a collection of fine-grained access privileges. Example:
     * Admin predefines roles that provides user a set of permissions (SELECT,
     * INSERT, ..). The user can then specify a predefined role on a connection to
     * execute their Cloud Spanner query. The role is passthrough here. If the
     * user is not authorized to use the specified role, they get an error. This
     * validation happens on Cloud Spanner.
     * See https://cloud.google.com/spanner/docs/fgac-about for more details.
     * REQUIRES: database role name must start with uppercase/lowercase letter
     * and only contain uppercase/lowercase letters, numbers, and underscores.
     *
     * Generated from protobuf field <code>string database_role = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDatabaseRole($var)
    {
        GPBUtil::checkString($var, True);
        $this->database_role = $var;

        return $this;
    }

}

