<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/index_endpoint_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\CreateIndexEndpointRequest;
use Google\Cloud\AIPlatform\V1\DeleteIndexEndpointRequest;
use Google\Cloud\AIPlatform\V1\DeployIndexRequest;
use Google\Cloud\AIPlatform\V1\DeployedIndex;
use Google\Cloud\AIPlatform\V1\GetIndexEndpointRequest;
use Google\Cloud\AIPlatform\V1\IndexEndpoint;
use Google\Cloud\AIPlatform\V1\ListIndexEndpointsRequest;
use Google\Cloud\AIPlatform\V1\ListIndexEndpointsResponse;
use Google\Cloud\AIPlatform\V1\MutateDeployedIndexRequest;
use Google\Cloud\AIPlatform\V1\UndeployIndexRequest;
use Google\Cloud\AIPlatform\V1\UpdateIndexEndpointRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: A service for managing Vertex AI's IndexEndpoints.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $indexEndpointServiceClient = new IndexEndpointServiceClient();
 * try {
 *     $formattedParent = $indexEndpointServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $indexEndpoint = new IndexEndpoint();
 *     $operationResponse = $indexEndpointServiceClient->createIndexEndpoint($formattedParent, $indexEndpoint);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $indexEndpointServiceClient->createIndexEndpoint($formattedParent, $indexEndpoint);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $indexEndpointServiceClient->resumeOperation($operationName, 'createIndexEndpoint');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $indexEndpointServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class IndexEndpointServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.IndexEndpointService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $indexNameTemplate;

    private static $indexEndpointNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/index_endpoint_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/index_endpoint_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/index_endpoint_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/index_endpoint_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getIndexNameTemplate()
    {
        if (self::$indexNameTemplate == null) {
            self::$indexNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/indexes/{index}'
            );
        }

        return self::$indexNameTemplate;
    }

    private static function getIndexEndpointNameTemplate()
    {
        if (self::$indexEndpointNameTemplate == null) {
            self::$indexEndpointNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}'
            );
        }

        return self::$indexEndpointNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'index' => self::getIndexNameTemplate(),
                'indexEndpoint' => self::getIndexEndpointNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a index
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $index
     *
     * @return string The formatted index resource.
     */
    public static function indexName($project, $location, $index)
    {
        return self::getIndexNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'index' => $index,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * index_endpoint resource.
     *
     * @param string $project
     * @param string $location
     * @param string $indexEndpoint
     *
     * @return string The formatted index_endpoint resource.
     */
    public static function indexEndpointName(
        $project,
        $location,
        $indexEndpoint
    ) {
        return self::getIndexEndpointNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'index_endpoint' => $indexEndpoint,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - index: projects/{project}/locations/{location}/indexes/{index}
     * - indexEndpoint: projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates an IndexEndpoint.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $formattedParent = $indexEndpointServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $indexEndpoint = new IndexEndpoint();
     *     $operationResponse = $indexEndpointServiceClient->createIndexEndpoint($formattedParent, $indexEndpoint);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $indexEndpointServiceClient->createIndexEndpoint($formattedParent, $indexEndpoint);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $indexEndpointServiceClient->resumeOperation($operationName, 'createIndexEndpoint');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param string        $parent        Required. The resource name of the Location to create the IndexEndpoint in.
     *                                     Format: `projects/{project}/locations/{location}`
     * @param IndexEndpoint $indexEndpoint Required. The IndexEndpoint to create.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createIndexEndpoint(
        $parent,
        $indexEndpoint,
        array $optionalArgs = []
    ) {
        $request = new CreateIndexEndpointRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setIndexEndpoint($indexEndpoint);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateIndexEndpoint',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes an IndexEndpoint.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $formattedName = $indexEndpointServiceClient->indexEndpointName('[PROJECT]', '[LOCATION]', '[INDEX_ENDPOINT]');
     *     $operationResponse = $indexEndpointServiceClient->deleteIndexEndpoint($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $indexEndpointServiceClient->deleteIndexEndpoint($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $indexEndpointServiceClient->resumeOperation($operationName, 'deleteIndexEndpoint');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the IndexEndpoint resource to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteIndexEndpoint($name, array $optionalArgs = [])
    {
        $request = new DeleteIndexEndpointRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteIndexEndpoint',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deploys an Index into this IndexEndpoint, creating a DeployedIndex within
     * it.
     * Only non-empty Indexes can be deployed.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $formattedIndexEndpoint = $indexEndpointServiceClient->indexEndpointName('[PROJECT]', '[LOCATION]', '[INDEX_ENDPOINT]');
     *     $deployedIndex = new DeployedIndex();
     *     $operationResponse = $indexEndpointServiceClient->deployIndex($formattedIndexEndpoint, $deployedIndex);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $indexEndpointServiceClient->deployIndex($formattedIndexEndpoint, $deployedIndex);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $indexEndpointServiceClient->resumeOperation($operationName, 'deployIndex');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param string        $indexEndpoint Required. The name of the IndexEndpoint resource into which to deploy an
     *                                     Index. Format:
     *                                     `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * @param DeployedIndex $deployedIndex Required. The DeployedIndex to be created within the IndexEndpoint.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deployIndex(
        $indexEndpoint,
        $deployedIndex,
        array $optionalArgs = []
    ) {
        $request = new DeployIndexRequest();
        $requestParamHeaders = [];
        $request->setIndexEndpoint($indexEndpoint);
        $request->setDeployedIndex($deployedIndex);
        $requestParamHeaders['index_endpoint'] = $indexEndpoint;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeployIndex',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets an IndexEndpoint.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $formattedName = $indexEndpointServiceClient->indexEndpointName('[PROJECT]', '[LOCATION]', '[INDEX_ENDPOINT]');
     *     $response = $indexEndpointServiceClient->getIndexEndpoint($formattedName);
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the IndexEndpoint resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\IndexEndpoint
     *
     * @throws ApiException if the remote call fails
     */
    public function getIndexEndpoint($name, array $optionalArgs = [])
    {
        $request = new GetIndexEndpointRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIndexEndpoint',
            IndexEndpoint::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists IndexEndpoints in a Location.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $formattedParent = $indexEndpointServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $indexEndpointServiceClient->listIndexEndpoints($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $indexEndpointServiceClient->listIndexEndpoints($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location from which to list the
     *                             IndexEndpoints. Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Optional. An expression for filtering the results of the request. For field
     *           names both snake_case and camelCase are supported.
     *
     *           * `index_endpoint` supports = and !=. `index_endpoint` represents the
     *           IndexEndpoint ID, ie. the last segment of the IndexEndpoint's
     *           [resourcename][google.cloud.aiplatform.v1.IndexEndpoint.name].
     *           * `display_name` supports =, != and regex()
     *           (uses [re2](https://github.com/google/re2/wiki/Syntax) syntax)
     *           * `labels` supports general map functions that is:
     *           `labels.key=value` - key:value equality
     *           `labels.key:* or labels:key - key existence
     *           A key including a space must be quoted. `labels."a key"`.
     *
     *           Some examples:
     *           * `index_endpoint="1"`
     *           * `display_name="myDisplayName"`
     *           * `regex(display_name, "^A") -> The display name starts with an A.
     *           * `labels.myKey="myValue"`
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type FieldMask $readMask
     *           Optional. Mask specifying which fields to read.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listIndexEndpoints($parent, array $optionalArgs = [])
    {
        $request = new ListIndexEndpointsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListIndexEndpoints',
            $optionalArgs,
            ListIndexEndpointsResponse::class,
            $request
        );
    }

    /**
     * Update an existing DeployedIndex under an IndexEndpoint.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $formattedIndexEndpoint = $indexEndpointServiceClient->indexEndpointName('[PROJECT]', '[LOCATION]', '[INDEX_ENDPOINT]');
     *     $deployedIndex = new DeployedIndex();
     *     $operationResponse = $indexEndpointServiceClient->mutateDeployedIndex($formattedIndexEndpoint, $deployedIndex);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $indexEndpointServiceClient->mutateDeployedIndex($formattedIndexEndpoint, $deployedIndex);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $indexEndpointServiceClient->resumeOperation($operationName, 'mutateDeployedIndex');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param string        $indexEndpoint Required. The name of the IndexEndpoint resource into which to deploy an
     *                                     Index. Format:
     *                                     `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * @param DeployedIndex $deployedIndex Required. The DeployedIndex to be updated within the IndexEndpoint.
     *                                     Currently, the updatable fields are [DeployedIndex][automatic_resources]
     *                                     and [DeployedIndex][dedicated_resources]
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function mutateDeployedIndex(
        $indexEndpoint,
        $deployedIndex,
        array $optionalArgs = []
    ) {
        $request = new MutateDeployedIndexRequest();
        $requestParamHeaders = [];
        $request->setIndexEndpoint($indexEndpoint);
        $request->setDeployedIndex($deployedIndex);
        $requestParamHeaders['index_endpoint'] = $indexEndpoint;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'MutateDeployedIndex',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Undeploys an Index from an IndexEndpoint, removing a DeployedIndex from it,
     * and freeing all resources it's using.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $formattedIndexEndpoint = $indexEndpointServiceClient->indexEndpointName('[PROJECT]', '[LOCATION]', '[INDEX_ENDPOINT]');
     *     $deployedIndexId = 'deployed_index_id';
     *     $operationResponse = $indexEndpointServiceClient->undeployIndex($formattedIndexEndpoint, $deployedIndexId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $indexEndpointServiceClient->undeployIndex($formattedIndexEndpoint, $deployedIndexId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $indexEndpointServiceClient->resumeOperation($operationName, 'undeployIndex');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param string $indexEndpoint   Required. The name of the IndexEndpoint resource from which to undeploy an
     *                                Index. Format:
     *                                `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * @param string $deployedIndexId Required. The ID of the DeployedIndex to be undeployed from the
     *                                IndexEndpoint.
     * @param array  $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function undeployIndex(
        $indexEndpoint,
        $deployedIndexId,
        array $optionalArgs = []
    ) {
        $request = new UndeployIndexRequest();
        $requestParamHeaders = [];
        $request->setIndexEndpoint($indexEndpoint);
        $request->setDeployedIndexId($deployedIndexId);
        $requestParamHeaders['index_endpoint'] = $indexEndpoint;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UndeployIndex',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates an IndexEndpoint.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $indexEndpoint = new IndexEndpoint();
     *     $updateMask = new FieldMask();
     *     $response = $indexEndpointServiceClient->updateIndexEndpoint($indexEndpoint, $updateMask);
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param IndexEndpoint $indexEndpoint Required. The IndexEndpoint which replaces the resource on the server.
     * @param FieldMask     $updateMask    Required. The update mask applies to the resource. See
     *                                     [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\IndexEndpoint
     *
     * @throws ApiException if the remote call fails
     */
    public function updateIndexEndpoint(
        $indexEndpoint,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateIndexEndpointRequest();
        $requestParamHeaders = [];
        $request->setIndexEndpoint($indexEndpoint);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['index_endpoint.name'] = $indexEndpoint->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateIndexEndpoint',
            IndexEndpoint::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $response = $indexEndpointServiceClient->getLocation();
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $indexEndpointServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $indexEndpointServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $indexEndpointServiceClient->getIamPolicy($resource);
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $indexEndpointServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $indexEndpointServiceClient = new IndexEndpointServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $indexEndpointServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $indexEndpointServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
