<!DOCTYPE html>
<html lang="en">

<head>
    <?php include('./assets/includes/stylews.php'); ?>

    <!-- custom css -->
    <link rel="stylesheet" href="./assets/style-wl.css" />
</head>

<body>

    <!-- header section -->
    <?php
    $total_page = 26;
    $current_page = 6;
    include('./assets/includes/headerws.php');
    ?>
    <!-- header sec end -->

    <!-- choose sec -->
    <form action="./qA1.5.php" method="post">
        <div class="template-layout common-box" id="section7">
            <div class="zone-container">
                <h2 class="title-md">Choose your target zones</h2>
                <div class="zone-inner-container">
                    <div class="zone-image-container">
                        <div class="lazyload-wrapper">
                            <img id="section-7-image" class="zone-girl-img" src="https://web.appscdn.io/web/WebDivisionFiles/Public/Walkfit(w)/indoor/Rework/target_zones.png" alt="" class="sc-jEACwC biwGkO">
                        </div>
                        <div class="ZonesImage__ImageLayersContainer-sc-1dk37f6-2 hsHsNo">
                            <div class="lazyload-wrapper"><img id="lower-back" src="https://web.appscdn.io/web/WebDivisionFiles/Public/Walkfit(w)/indoor/Rework/lower_back.png" alt="" class="girl-layer-img d-none"></div>
                            <div class="lazyload-wrapper"><img id="belly" src="https://web.appscdn.io/web/WebDivisionFiles/Public/Walkfit(w)/indoor/Rework/belly.png" alt="" class="girl-layer-img d-none"></div>
                            <div class="lazyload-wrapper"><img id="buttocks" src="https://web.appscdn.io/web/WebDivisionFiles/Public/Walkfit(w)/indoor/Rework/buttocks.png" alt="" class="girl-layer-img d-none"></div>
                            <div class="lazyload-wrapper"><img id="hips" src="https://web.appscdn.io/web/WebDivisionFiles/Public/Walkfit(w)/indoor/Rework/hips.png" alt="" class="girl-layer-img d-none"></div>
                            <div class="lazyload-wrapper"><img id="knees" src="https://web.appscdn.io/web/WebDivisionFiles/Public/Walkfit(w)/indoor/Rework/knees_zone.png" alt="" class="girl-layer-img d-none"></div>
                            <div class="lazyload-wrapper"><img id="calves" src="https://web.appscdn.io/web/WebDivisionFiles/Public/Walkfit(w)/indoor/Rework/calves.png" alt="" class="girl-layer-img d-none"></div>
                        </div>
                    </div>
                    <div class="zone-button-container">
                        <div class="zone-option-btn">
                            <input type="checkbox" data-id="lower-back" class="img-display-checkbox">
                            <div class="zone-image-option">Lower back</div>
                        </div>
                        <div class="zone-option-btn">
                            <input type="checkbox" data-id="belly" class="img-display-checkbox">
                            <div class="zone-image-option">Belly</div>
                        </div>
                        <div class="zone-option-btn">
                            <input type="checkbox" data-id="buttocks" class="img-display-checkbox">
                            <div class="zone-image-option">Buttocks</div>
                        </div>
                        <div class="zone-option-btn">
                            <input type="checkbox" data-id="hips" class="img-display-checkbox">
                            <div class="zone-image-option">Hips</div>
                        </div>
                        <div class="zone-option-btn">
                            <input type="checkbox" data-id="knees" class="img-display-checkbox">
                            <div class="zone-image-option">Knees</div>
                        </div>
                        <div class="zone-option-btn">
                            <input type="checkbox" data-id="calves" class="img-display-checkbox">
                            <div class="zone-image-option">Calves</div>
                        </div>
                        <div class="zone-option-btn">
                            <input type="checkbox" data-id="whole-body" class="img-display-checkbox" id="whole-body-checkbox" checked>
                            <div class="zone-image-option">Whole body</div>
                        </div>
                    </div>
                </div>
                <div class="continue-box">
                    <div class="continue-overlay"></div>
                    <div class="continue-btn-box next-section">
                        <button disabled type="submit" class="btn" id="continue-btn">Continue</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!-- choose sec end -->

    <?php include('./assets/includes/script.php'); ?>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const checkboxes = document.querySelectorAll('.img-display-checkbox');
            const continueButton = document.getElementById('continue-btn');
            const wholeBodyCheckbox = document.getElementById('whole-body-checkbox');

            const updateContinueButton = () => {
                let checkedCount = 0;
                checkboxes.forEach(checkbox => {
                    if (checkbox.checked && checkbox.id !== 'whole-body-checkbox') {
                        checkedCount++;
                    }
                });

                if (checkedCount > 0 || (checkedCount === 0 && wholeBodyCheckbox.checked)) {
                    continueButton.disabled = false;
                } else {
                    continueButton.disabled = true;
                }
            };

            checkboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function () {
                    if (checkbox.id === 'whole-body-checkbox' && checkbox.checked) {
                        checkboxes.forEach(box => {
                            if (box.id !== 'whole-body-checkbox') {
                                box.checked = false;
                            }
                        });
                    } else if (checkbox.checked) {
                        wholeBodyCheckbox.checked = false;
                    }
                    updateContinueButton();
                });
            });

            // Initialize the continue button state
            continueButton.disabled = true;
            updateContinueButton();
        });
    </script>

</body>

</html>
