<?php
session_start();
// Initialize variables
$payment_id = $statusMsg = '';
$ordStatus = 'error';
$id = '';

// Check whether stripe token is not empty
if (!empty($_POST['token'])) {
    
    // Get Token, Card and User Info from Form
    $token = $_POST['token']['id'];  // Use the 'id' field of the token object
    $name = isset($_POST['holdername']) ? $_POST['holdername'] : '';
    $email = isset($_POST['email']) ? $_POST['email'] : '';

// Get selected plan
$selectedPlan = $_POST['selectedPlan'];
if ($selectedPlan == 1) {
    $price = 3895; // $38.95 in cents (monthly subscription after trial)
    $setupFee = 312; // $3.12 in cents (reduced from $5.15)
    $planInterval = 'month';
    $trialPeriod = 6 * 24 * 60 * 60; // 6 days in seconds
    $productName = '1-WEEK TRIAL';
} elseif ($selectedPlan == 3) {
    $price = 3895; // $38.95 in cents (monthly subscription after trial)
    $setupFee = 2995; // $29.95 in cents (reduced from $38.95)
    $planInterval = 'month';
    $interval_count = 1;
    $productName = '4-WEEK PLAN';
    $trialPeriod = 29 * 24 * 60 * 60; // 29 days in seconds
} elseif ($selectedPlan == 6) {
    $price = 6665; // $66.65 in cents (subscription after trial)
    $setupFee = 1499; // $14.99 in cents (reduced from $19.29)
    $planInterval = 'day';
    $interval_count = 83; // Billed every 83 days
    $productName = '12-WEEK PLAN';
    $trialPeriod = 83 * 24 * 60 * 60; // 83 days in seconds
}

    // Include Stripe PHP Library
    require_once('stripe-php/init.php');

    // Set your secret key
    \Stripe\Stripe::setApiKey('sk_test_51OuhoIRp9feDzI9FFRzsNuKH6oO9r2AT81yPhgRATKBpufd1cWVXU4dkkNe03BwtON0jiPARS4RaxX67a1f6rVRh00QTOzKorX');

    try {
        // Create a customer in Stripe
        $customer = \Stripe\Customer::create([
            'email' => $email,
            'source' => $token,  // Use the token ID
            'description' => 'Customer for ' . $email
        ]);

        // Charge the customer for setup fee
        $charge = \Stripe\Charge::create([
            'customer' => $customer->id,
            'amount' => $setupFee,
            'currency' => 'usd',
            'description' => 'One-time setup fee'
        ]);

        // Create a product (if not already created)
        $product = \Stripe\Product::create([
            'name' => $productName,
            'type' => 'service',
        ]);

        // Create a plan with the specified price and interval
        $plan = \Stripe\Plan::create([
            'amount' => $price,
            'interval' => $planInterval,
            'interval_count' => $interval_count,
            'product' => $product->id,
            'currency' => 'usd',
        ]);

        // Subscribe the customer to the plan
        $subscription = \Stripe\Subscription::create([
            'customer' => $customer->id,
            'items' => [['plan' => $plan->id]],
            'trial_end' => time() + $trialPeriod, // Set trial period manually
        ]);

        // If everything is successful
        $ordStatus = 'success';
        $statusMsg = 'Your Payment has been Successful!';
        $payment_id = $charge->id;// Payment ID or other identifier
        $_SESSION['payment_id']=$payment_id;
        $_SESSION['email']=$email;
        // Redirect to upsell page
        // header("Location: upsell-1.php");
        // exit();
        
    } catch (Exception $e) {
        $statusMsg = "Transaction has been failed: " . $e->getMessage();
    }
} else {
    $statusMsg = "Error on form submission.";
}

// Prepare JSON response
$response = array(
    'status' => $ordStatus,
    'message' => $statusMsg,
    'payment_id' => $payment_id,
    'email' =>$email
);

// Send JSON response back to the AJAX request
header('Content-Type: application/json');
echo json_encode($response);
?>
