<?php
session_start();
// Initialize variables
$payment_id = $statusMsg = '';
$ordStatus = 'error';
$id = '';

// Check whether stripe token is not empty
if (!empty($_POST['token'])) {
    
    // Get Token, Card and User Info from Form
    $token = $_POST['token']['id'];
    $name = $_POST['holdername'] ?? '';
    $email = $_POST['email'] ?? '';

    // Retrieve plan details from the form
    $selectedPlan = $_POST['selectedPlan'];

    // Define pricing and parameters based on the selected plan
    switch ($selectedPlan) {
        case "1-WEEK":
            $setupFee = 499; // $4.99 in cents
            $recurringPrice = 2999; // $29.99 recurring price in cents
            $planInterval = 'day';
            $interval_count = 6; // Charged on the 6th day
            $productName = '1-WEEK TRIAL';
            break;
        case "1-MONTH":
            $setupFee = 1799; // $17.99 in cents
            $recurringPrice = 2999; // $29.99 recurring price in cents
            $planInterval = 'day';
            $interval_count = 30; // Charged on the 30th day
            $productName = '1-MONTH PLAN';
            break;
        case "3-MONTH":
            $setupFee = 2999; // $29.99 in cents
            $recurringPrice = 2999; // $29.99 recurring price in cents
            $planInterval = 'day';
            $interval_count = 89; // Charged every 89 days
            $productName = '3-MONTH PLAN';
            break;
        default:
            $statusMsg = "Invalid Plan Selected.";
            sendResponse($ordStatus, $statusMsg);
            exit;
    }

    // Include Stripe PHP Library
    require_once('stripe-php/init.php');

    // Set your secret key: replace this with your actual secret key
    \Stripe\Stripe::setApiKey('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');

    try {
        // Create a customer in Stripe
        $customer = \Stripe\Customer::create([
            'email' => $email,
            'source' => $token,
            'description' => 'Customer for ' . $email
        ]);

        // Create a product (if not already created)
        $product = \Stripe\Product::create([
            'name' => $productName,
            'type' => 'service',
        ]);

        // Create a plan with the specified price and interval for recurring charges
        $plan = \Stripe\Plan::create([
            'amount' => $recurringPrice,
            'interval' => $planInterval,
            'interval_count' => $interval_count,
            'product' => $product->id,
            'currency' => 'usd',
        ]);

        // Subscribe the customer to the plan
        $subscription = \Stripe\Subscription::create([
            'customer' => $customer->id,
            'items' => [['plan' => $plan->id]],
            'trial_end' => strtotime("+{$interval_count} days"), // Set the trial end to the charge day
        ]);

        // Charge the setup fee immediately
        $charge = \Stripe\Charge::create([
            'customer' => $customer->id,
            'amount' => $setupFee,
            'currency' => 'usd',
            'description' => 'Setup fee for ' . $productName
        ]);

        // If everything is successful
        $ordStatus = 'success';
        $statusMsg = 'Your Payment has been Successful!';
        $payment_id = $subscription->id; // Use Subscription ID as payment ID

        $_SESSION['payment_id'] = $payment_id;
        $_SESSION['email'] = $email;
        
    } catch (Exception $e) {
        $statusMsg = "Transaction has been failed: " . $e->getMessage();
    }
} else {
    $statusMsg = "Error on form submission.";
}

sendResponse($ordStatus, $statusMsg,$payment_id);

function sendResponse($status, $message, $paymentId = null, $email = null) {
    $response = [
        'status' => $status,
        'message' => $message,
        'payment_id' => $paymentId,
        'email' => $email
    ];

    header('Content-Type: application/json');
    echo json_encode($response);
}
?>
