<?php 
    if (isset($_POST['submit'])) {
        $productId = $_POST['id'];
    } else {
        $productId = '';
    }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Stripe Payment Gateway Integration in PHP</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="//netdna.bootstrapcdn.com/bootstrap/3.1.0/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="css/design.css">
</head>
<body>
    <div class="container">
        <h2 style="text-align: center; color: blue;">Stripe Payment Gateway Integration in PHP</h2>
        <br>
        <div class="row">
            <div class="col-xs-12 col-md-4">
                <div class="panel panel-default credit-card-box">
                    <div class="panel-heading display-table">
                        <div class="row display-tr">
                            <h3 class="panel-title display-td">Payment Details</h3>
                            <div class="display-td">
                                <img class="img-responsive pull-right" src="http://i76.imgup.net/accepted_c22e0.png">
                            </div>
                        </div>
                    </div>
                    <div class="panel-body">
                        <div class="payment-status" style="color: red;"></div>
                        <form role="form" action="stripe_payment.php" method="POST" name="cardpayment" id="payment-form">
                            <input type="hidden" name="productId" value="<?php echo $productId; ?>"/>
                            <input type="hidden" name="email" id="hiddenEmailField" value=""/>
                            <div class="custom-form-group">
                                <label for="card_number" class="sr-only">Card Number</label>
                                <input type="text" class="custom-form-control" name="card_number" placeholder="Credit or Debit Card Number" autocomplete="cc-number" id="card_number" maxlength="19" data-stripe="number" required />
                            </div>
                            <div class="custom-form-row">
                                <div class="custom-form-group">
                                    <label for="expiry_date" class="sr-only">Expiry Date</label>
                                    <input type="text" class="custom-form-control" name="expiry_date" placeholder="Expiry Date (MM/YY)" id="expiry_date" maxlength="5" required />
                                </div>
                                <div class="custom-form-group">
                                    <label for="cvv" class="sr-only">CVC</label>
                                    <input type="text" class="custom-form-control" name="cvv" placeholder="CVV/CVC" autocomplete="cc-csc" id="cvv" required />
                                </div>
                            </div>
                            <button class="btn btn-success btn-lg btn-block submit" type="submit" id="payBtn">Continue</button>
                            <p class="text-center mt-2" style="font-size: 12px;">Payments are secure & encrypted</p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="//netdna.bootstrapcdn.com/bootstrap/3.1.0/js/bootstrap.min.js"></script>
    <script src="https://js.stripe.com/v2/"></script>
    <script src="js/jquery.min.js"></script>
    <script>
        Stripe.setPublishableKey('pk_test_51OuhoIRp9feDzI9F0kpwFa40Ltt7NLjTvIyJDUvSFJ88tTxOCdcRI16Bd9UcjE3AAIYBw161EeAmfxr1xr6bJ8Ej003F6ZskqC');

        function stripeResponseHandler(status, response) {
            if (response.error) {
                $('#payBtn').removeAttr("disabled");
                $(".payment-status").html('<p>' + response.error.message + '</p>');
            } else {
                var form$ = $("#payment-form");
                var token = response.id;
                form$.append("<input type='hidden' name='stripeToken' value='" + token + "' />");
                form$.get(0).submit();
            }
        }

        $(document).ready(function() {
            // Autofill the email field from local storage
            var email = localStorage.getItem('userEmail');
            if (email) {
                $('#hiddenEmailField').val(email);
            }

            $("#payment-form").submit(function() {
                $('#payBtn').attr("disabled", "disabled");
                Stripe.createToken({
                    number: $('#card_number').val(),
                    exp_month: $('#expiry_date').val().split('/')[0],
                    exp_year: $('#expiry_date').val().split('/')[1],
                    cvc: $('#cvv').val()
                }, stripeResponseHandler);
                return false;
            });
        });
    </script>
</body>
</html>
