<!DOCTYPE html>
<html lang="en">

<head>
    <?php include('./assets/includes/style.php'); ?>

    <!-- custom css -->
    <link rel="stylesheet" href="./assets/style-ws.css" />
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap');

        body {
            font-family: 'Roboto', sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            background-color: #F7F6F3;
        }


        /*.template-layout.common-box {*/
        /*    padding: 20px;*/
        /*    margin: 20px auto;*/
        /*    max-width: 600px;*/
        /*    background-color: #F7F6F3;*/
        /*    border-radius: 8px;*/
        /*    display: flex;*/
        /*    flex-direction: column;*/
        /*    justify-content: space-between;*/
        /*    height: 100%;*/
        /*}*/

        .main-title {
            font-size: 2em;
            font-weight: bold;
            color: #000;
            text-align: center;
            margin-bottom: 10px;
            line-height: 1.2;
        }
        .female-group-img {
            text-align: center;
            margin-bottom: 20px;
            position: relative;
        }

        .female-group-img img {
            max-width: 80%;
            border-radius: 8px;
            object-fit: cover;
            mask-image: linear-gradient(to right, rgba(0, 0, 0, 0.1), rgba(0, 0, 0, 1) 10%, rgba(0, 0, 0, 1) 90%, rgba(0, 0, 0, 0.1));
            -webkit-mask-image: linear-gradient(to right, rgba(0, 0, 0, 0.1), rgba(0, 0, 0, 1) 10%, rgba(0, 0, 0, 1) 90%, rgba(0, 0, 0, 0.1));
        }


       .continue-btn-box {
            display: inline-block;
            position: relative;
            left: var(--btn-left, 80px);
            right: var(--btn-right, 20px);
            top: var(--btn-top, 87px);
            bottom: var(--btn-bottom, 0px);
        }

        .btn {
            font-size: 1.2em;
            font-weight: bold;
            color: #fff;
            background-color: #5e35b1;
            padding: 15px 30px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .btn:hover {
            background-color: #4527a0;
        }

        #pound-counter {
            display: inline-block;
            transition: transform 0.3s ease, opacity 0.3s ease;
        }

@media (max-width: 576px) {
        .header_sec img {
            width: 150px;
        }

        /*.template-layout.common-box {*/
        /*    padding: 20px;*/
        /*}*/

        .main-title {
            font-size: 1.5em;
        }

        .btn {
            font-size: 1em;
            padding: 10px 20px;
            position: relative; /* Ensure the button can be positioned */
            top: -80px; /* Adjust this value to move the button down */
            left: -80px; /* Adjust this value to move the button to the right */
        }

        .female-group-img img {
            max-width: 100%;
        }
    }
    </style>
</head>

<body>

    <!-- header section -->
    <?php
    if (count($_POST) < 1) {
        echo "<script>window.location.href='index.php';</script>";
        exit;
    }

    $total_page = 26;
    $current_page = 2;
    if (isset($_POST['gender'])) {
        $gender = $_POST['gender'];
    }

    include('./assets/includes/header-2.php');
    ?>

    <div class="template-layout common-box">
        <h1 class="main-title">5,200,000+ Women Have Transformed Their Lives</h1>
        <h5 class="sub-title">
            "Experience the success of women who have collectively lost over 
            <span id="pound-counter">65,371,483</span> pounds fasting through our with MyFastingMentorProgram."
        </h5>
        <div class="female-group-img">
            <img src="https://imagedelivery.net/Ae8sF6FuGEmwqSo_o8S3HQ/6dc53958-74fc-41e4-583a-7916300fd600/public" alt="7,600,000+ Women">
        </div>
        <form action="achieve1.0.php" method="POST" id="">
            <div class="continue-box">
                <div class="continue-btn-box next-section">
                    <button type="submit" class="btn">Continue</button>
                </div>
            </div>
        </form>
    </div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const counterElement = document.getElementById('pound-counter');
        let currentNumber = 65371483;
        const maxNumber = 87628417;
        let baseInterval = 1100; // Start with 1.1 seconds
        const maxInterval = 8300; // Maximum interval of 8.3 seconds
        let incrementCount = 0;

        function incrementNumber() {
            if (currentNumber < maxNumber) {
                currentNumber++;
                counterElement.style.opacity = '0';
                setTimeout(() => {
                    counterElement.textContent = currentNumber.toLocaleString();
                    counterElement.style.opacity = '1';
                }, 300);

                incrementCount++;

                // Increase interval time gradually
                if (incrementCount <= 2) {
                    baseInterval = 1100; // First two updates are quick
                } else if (incrementCount === 3) {
                    baseInterval = 7000 + Math.random() * 1000; // Long pause after the first two updates
                } else {
                    // Gradually increase the interval with some randomness
                    baseInterval = Math.min(baseInterval + (Math.random() * 500), maxInterval);

                    // Occasionally reset to a quicker update interval to simulate dynamic behavior
                    if (Math.random() < 0.1) { // 10% chance for a quick update
                        baseInterval = Math.random() * (maxInterval - 1500) + 1500; // Random interval between 1.5s and maxInterval
                    }
                }

                // Schedule the next increment with the updated interval
                setTimeout(incrementNumber, baseInterval);
            }
        }

        incrementNumber();
    });
</script>
</body>

</html>
