<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('./assets/includes/style.php'); ?>

    <!-- custom css -->
    <link rel="stylesheet" href="./assets/style-wl.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/brands.min.css" integrity="sha512-DJLNx+VLY4aEiEQFjiawXaiceujj5GA7lIY8CHCIGQCBPfsEG0nGz1edb4Jvw1LR7q031zS5PpPqFuPA8ihlRA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/fontawesome.min.css" integrity="sha512-UuQ/zJlbMVAw/UU8vVBhnI4op+/tFOpQZVT+FormmIEhRSCnJWyHiBbEVgM4Uztsht41f3FzVWgLuwzUqOObKw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Merriweather:wght@300;400;700&display=swap" rel="stylesheet">

    <style>
 .debug-container {
            border: none; /* Remove the border */
            background-color: transparent; /* Remove the background color */
            position: absolute;
            z-index: 1000;
        }

        .relative-container {
            position: relative;
            width: 600px; /* Match the width of the graph */
            margin: 0 auto; /* Center the container */
            margin-top: 200px; /* Adjust this value to shift the section down */
        }

        .your-weight {
            position: absolute;
            top: -88px;
            left: 10px;
            color: black;
            background-color: #f0f0f0;
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 12px;
            font-weight: 700;
            white-space: nowrap;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
            border: 1px solid #ccc;
        }

        .now {
            position: absolute;
            top: -43px; /* Desktop positioning */
            left: 51px; /* Desktop positioning */
            background-color: #FFB801;
            color: white;
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 12px;
            font-weight: 700;
            white-space: nowrap;
        }

        .now::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 0;
            height: 0;
            border-left: 10px solid transparent;
            border-right: 10px solid transparent;
            border-top: 10px solid #FFB801;
        }

        .dot {
            position: absolute;
            top: -2px; /* Desktop positioning */
            left: 61.5px; /* Desktop positioning */
            width: 24px;
            height: 23px;
            background-color: #ffffff;
            border: 5px solid #cccccc;
            border-radius: 50%;
        }

/* Mobile specific styles */
@media (max-width: 768px) {
    .relative-container {
        width: 100%;
        margin-top: 72px; /* Adjust this value as needed for mobile */
    }
    .your-weight {
        top: -84px; /* Mobile positioning */
        left: 15px; /* Mobile positioning */
    }
    .now {
        top: -40px; /* Positioned slightly below "Your Weight" */
        left: 26px; /* Mobile positioning */
    }
    .dot {
        top: -0px; /* Positioned slightly below the "Now" button */
        left: 39px; /* Align with "Your Weight" */
    }
}

/* Hide the desktop version on mobile devices */
@media (max-width: 768px) {
    .desktop-only {
        display: none;
    }
}

/* Hide the mobile version on desktop devices */
@media (min-width: 769px) {
    .mobile-only {
        display: none;
    }
}
    </style>
    
</head>

<body>
    <!-- header section -->
    <?php include('./assets/includes/header-2.php'); ?>
    <!-- header sec end -->

    <!-- main section -->
    <form action="./email.php" method="post">
        <div class="main_sec question7">
            <div class="container">
                <div class="container-fluid category-container common-tile">
                    <div class="choose-wrap">
                        <div class="head text-center" style="font-family: 'Merriweather', serif; padding-top: 0px; margin-top: 90px;">
                            <h1 class="fw-bold mb-4 pb-3" style="font-size: 1.8rem; color: #000;">The last plan you’ll ever need to get in shape</h1>
                            <p class="mb-2 small" style="font-size: 1.2rem; color: #555; margin-top: -20px;">We predict you’ll be</p>
                            <p class="fw-bold mb-4 date" id="predictedWeight" style="color: #00845D; font-size: 1.5rem; margin-top: -2px;">333 lbs by *September 18, 2025</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php foreach ($_POST as $key => $value) {
            if (is_array($value)) {
                foreach ($value as $element) {
                    echo '<input type="hidden" name="' . $key . '[]" value="' . $element . '">';
                }
            } else {
                echo '<input type="hidden" name="' . $key . '" value="' . $value . '">';
            }
        } ?>

        <!-- Desktop Graph Section with overlayed labels and dot -->
        <div class="relative-container desktop-only">
            <!-- Graph SVG -->
            <div class="text-center graph-chart">
                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.dev/svgjs" width="600" height="300">
                    <defs>
                        <linearGradient id="SvgjsLinearGradient1000">
                            <stop stop-color="#ff0000" offset="0"></stop>
                            <stop stop-color="#ffe401" offset="0.25"></stop>
                            <stop stop-color="#2fe0b6" offset="0.8"></stop>
                        </linearGradient>
                    </defs>
                    <line x1="370" y1="238" x2="590" y2="245" stroke-dasharray="" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="480" y1="238" x2="590" y2="245" stroke-dasharray="" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="260" y1="238" x2="590" y2="245" stroke-dasharray="" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="150" y1="238" x2="590" y2="245" stroke-dasharray="" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="237" x2="590" y2="237" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="198" x2="590" y2="198" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="160" x2="590" y2="160" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="122" x2="590" y2="122" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="84" x2="590" y2="84" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="46" x2="590" y2="46" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="9" x2="590" y1="9" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <path d="M86.632 44.1732C78.4522 18.524878 50 10 41.62577 18H70V238H620V235.284C511.665 234.57 472.715 223.14 434.601 211.703C404.486 202.667 377.506 188.106 325.447 156.338C293.102 136.601 266.988 115.8339 226.402 102.2828C158.811 79.715 93.9117 66.9992 86.632 44.1732Z" fill="#bdc2cb" opacity="0.2"></path>
                    <path d="M75 14C61.903800000000004 16.35215 80.0077 14.531441000000001 88.2115 40.5004C95.5125 63.6117 160.603 76.4865 228.392 99.3364C269.098 113.0569 295.289 134.083 327.728 154.067C379.94 186.233 406.999 200.975 437.203 210.125C475.429 221.704 514.4929999999999 231.277 573 230.5" fill="none" stroke-linejoin="round" stroke-linecap="round" stroke-width="8" stroke="url(#SvgjsLinearGradient1000)" id="graphProgressiveLine" style="stroke-dasharray: 584.97; stroke-dashoffset: 584.97;"></path>
                    <circle r="12.5" cx="581.3" cy="230.5" fill="#ffffff" stroke-opacity="0.2" stroke-width="7" stroke="#000000" opacity="1"></circle>
                    <rect id="goalBox" width="58" height="38" rx="4" ry="4" fill="#349760" x="530" y="138" opacity="0" style="filter: drop-shadow(rgba(7, 21, 37, 0.1) 4px 4px 5px);"></rect>
                    <path d="M557.5,175 L567.5,175 L567.5,205 L557.5,175 Z" fill="#349760" opacity="0" id="goalPointer"></path>
                    <text id="goalText" x="560" y="154" fill="#ffffff" font-size="12px" font-weight="700" opacity="0" text-anchor="middle">
                        <tspan id="goalTitle" x="560">Goal</tspan>
                        <tspan id="goalWeight" x="560" dy="16">111.0</tspan>
                    </text>
                    <text x="15" y="16" fill="#9eaab7" font-weight="600" opacity="1" id="currentWeightText">200</text>
                    <text x="20" y="53" fill="#9eaab7" font-weight="600" opacity="1" id="text2">192.0</text>
                    <text x="20" y="91" fill="#9eaab7" font-weight="600" opacity="1" id="text3">184.0</text>
                    <text x="20" y="129" fill="#9eaab7" font-weight="600" opacity="1" id="text4">176.0</text>
                    <text x="20" y="167" fill="#9eaab7" font-weight="600" opacity="1" id="text5">168.0</text>
                    <text x="20" y="205" fill="#9eaab7" font-weight="600" opacity="1" id="text6">160.0</text>
                    <text x="20" y="244" fill="#9eaab7" font-weight="600" opacity="1" id="text7">152.0</text>
                    <text x="70" y="270" fill="#9eaab7" font-weight="600" font-size="13px" opacity="1" id="currentMonthText">July</text>
                    <text x="523" y="270" fill="#9eaab7" font-weight="600" font-size="13px" opacity="1" id="endMonthText">October</text>
                </svg>
            </div>
            <!-- "Your Weight" container -->
            <div class="your-weight">
                Your Weight
            </div>
            <!-- "Now" container -->
            <div class="now">
                Now
            </div>
            <!-- New white dot with gray outline -->
            <div class="dot" id="newCircle"></div>
        </div>

        <!-- Mobile Graph Section with overlayed labels and dot -->
        <div class="relative-container mobile-only">
            <!-- Graph SVG -->
            <div class="text-center graph-chart">
                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.dev/svgjs" width="100%" height="300" viewBox="0 0 620 300" preserveAspectRatio="xMinYMin meet">
                    <defs>
                        <linearGradient id="SvgjsLinearGradient1000">
                            <stop stop-color="#ff0000" offset="0"></stop>
                            <stop stop-color="#ffe401" offset="0.25"></stop>
                            <stop stop-color="#2fe0b6" offset="0.8"></stop>
                        </linearGradient>
                    </defs>
                    <line x1="370" y1="238" x2="590" y2="245" stroke-dasharray="" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="480" y1="238" x2="590" y2="245" stroke-dasharray="" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="260" y1="238" x2="590" y2="245" stroke-dasharray="" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="150" y1="238" x2="590" y2="245" stroke-dasharray="" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="237" x2="590" y2="237" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="198" x2="590" y2="198" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="160" x2="590" y2="160" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="122" x2="590" y2="122" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="84" x2="590" y2="84" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="46" x2="590" y2="46" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <line x1="70" y1="9" x2="590" y1="9" stroke-width="2" stroke="#cccccc" opacity="0.3"></line>
                    <path d="M86.632 44.1732C78.4522 18.524878 50 10 41.62577 18H70V238H620V235.284C511.665 234.57 472.715 223.14 434.601 211.703C404.486 202.667 377.506 188.106 325.447 156.338C293.102 136.601 266.988 115.8339 226.402 102.2828C158.811 79.715 93.9117 66.9992 86.632 44.1732Z" fill="#bdc2cb" opacity="0.2"></path>
                    <path d="M75 14C61.903800000000004 16.35215 80.0077 14.531441000000001 88.2115 40.5004C95.5125 63.6117 160.603 76.4865 228.392 99.3364C269.098 113.0569 295.289 134.083 327.728 154.067C379.94 186.233 406.999 200.975 437.203 210.125C475.429 221.704 514.4929999999999 231.277 573 230.5" fill="none" stroke-linejoin="round" stroke-linecap="round" stroke-width="8" stroke="url(#SvgjsLinearGradient1000)" id="mobileGraphProgressiveLine" style="stroke-dasharray: 584.97; stroke-dashoffset: 584.97;"></path>
                    <circle r="12.5" cx="581.3" cy="230.5" fill="#ffffff" stroke-opacity="0.2" stroke-width="7" stroke="#000000" opacity="1" id="mobileCircle"></circle>
                    <rect id="mobileGoalBox" width="58" height="38" rx="4" ry="4" fill="#349760" x="530" y="138" opacity="0" style="filter: drop-shadow(rgba(7, 21, 37, 0.1) 4px 4px 5px);"></rect>
                    <path d="M557.5,175 L567.5,175 L567.5,205 L557.5,175 Z" fill="#349760" opacity="0" id="mobileGoalPointer"></path>
                    <text id="mobileGoalText" x="560" y="154" fill="#ffffff" font-size="12px" font-weight="700" opacity="0" text-anchor="middle">
                        <tspan id="mobileGoalTitle" x="560">Goal</tspan>
                        <tspan id="mobileGoalWeight" x="560" dy="16">111.0</tspan>
                    </text>
                    <text x="15" y="16" fill="#9eaab7" font-weight="600" opacity="1" id="mobileCurrentWeightText">200</text>
                    <text x="20" y="53" fill="#9eaab7" font-weight="600" opacity="1" id="mobileText2">192.0</text>
                    <text x="20" y="91" fill="#9eaab7" font-weight="600" opacity="1" id="mobileText3">184.0</text>
                    <text x="20" y="129" fill="#9eaab7" font-weight="600" opacity="1" id="mobileText4">176.0</text>
                    <text x="20" y="167" fill="#9eaab7" font-weight="600" opacity="1" id="mobileText5">168.0</text>
                    <text x="20" y="205" fill="#9eaab7" font-weight="600" opacity="1" id="mobileText6">160.0</text>
                    <text x="20" y="244" fill="#9eaab7" font-weight="600" opacity="1" id="mobileText7">152.0</text>
                    <text x="70" y="270" fill="#9eaab7" font-weight="600" font-size="13px" opacity="1" id="mobileCurrentMonthText">July</text>
                    <text x="523" y="270" fill="#9eaab7" font-weight="600" font-size="13px" opacity="1" id="mobileEndMonthText">October</text>
                </svg>
            </div>
            <!-- "Your Weight" container -->
            <div class="your-weight">
                Your Weight
            </div>
            <!-- "Now" container -->
            <div class="now">
                Now
            </div>
            <!-- New white dot with gray outline -->
            <div class="dot" id="mobileNewCircle"></div>
        </div>

        <div class="text-center continue-btn">
            <button type="submit" class="btn messure_btn d-block">Continue</button>
        </div>
    </form>
    <!-- main sec end -->

    <?php include('./assets/includes/script.php'); ?>

    <script>
    document.addEventListener("DOMContentLoaded", function() {
        // Function to animate desktop graph
        function animateDesktopGraph() {
            var path = document.getElementById('graphProgressiveLine');
            var circle = document.querySelector('.desktop-only circle');
            var goalBox = document.getElementById('goalBox');
            var goalPointer = document.getElementById('goalPointer');
            var goalText = document.getElementById('goalText');
            var currentWeightText = document.getElementById('currentWeightText');
            var currentMonthText = document.getElementById('currentMonthText');
            var endMonthText = document.getElementById('endMonthText');
            var textElements = [
                document.getElementById('text2'),
                document.getElementById('text3'),
                document.getElementById('text4'),
                document.getElementById('text5'),
                document.getElementById('text6'),
                document.getElementById('text7')
            ];

            if (!path || !circle || !goalBox || !goalPointer || !goalText || !currentWeightText || !currentMonthText || !endMonthText || textElements.includes(null)) {
                console.error("Some elements not found in the DOM.");
                return;
            }

            var pathLength = path.getTotalLength();
            path.style.transition = path.style.WebkitTransition = 'none';
            path.style.strokeDasharray = pathLength + ' ' + pathLength;
            path.style.strokeDashoffset = pathLength;
            path.getBoundingClientRect();
            path.style.transition = path.style.WebkitTransition = 'stroke-dashoffset 4s ease-in-out';
            path.style.strokeDashoffset = '0';

            function showElements() {
                circle.style.opacity = '1';
                goalBox.style.opacity = '1';
                goalPointer.style.opacity = '1';
                goalText.style.opacity = '1';
                currentMonthText.style.opacity = '1';
                endMonthText.style.opacity = '1';
            }

            path.addEventListener('transitionend', showElements);

            // Pulling from localStorage without default values
            var currentWeight = parseFloat(localStorage.getItem('current_weight'));
            var targetWeight = parseFloat(localStorage.getItem('target_weight'));
            var weightLossPerWeek = 2.88;

            if (isNaN(currentWeight) || isNaN(targetWeight)) {
                console.error("Current weight or target weight not found in localStorage.");
                return;
            }

            currentWeightText.textContent = currentWeight.toFixed(1);
            document.getElementById('goalWeight').textContent = targetWeight.toFixed(1);

            var totalWeightToLose = currentWeight - targetWeight;
            var totalWeeks = Math.ceil(totalWeightToLose / weightLossPerWeek);

            // Calculate and set the dynamic x-axis dates
            var currentDate = new Date();
            var endDate = new Date(currentDate);
            endDate.setDate(currentDate.getDate() + totalWeeks * 7);

            var startMonth = currentDate.toLocaleString('default', { month: 'long' });
            var endMonth = endDate.toLocaleString('default', { month: 'long' });
            currentMonthText.textContent = startMonth;
            endMonthText.textContent = endMonth;

            // Update y-axis labels dynamically
            var yLabels = [];
            yLabels.push(currentWeight.toFixed(1)); // Starting with the current weight
            for (var i = 1; i < 6; i++) {
                yLabels.push((Math.random() * (currentWeight - targetWeight) + targetWeight).toFixed(1));
            }
            yLabels.push(targetWeight.toFixed(1)); // Ending with the target weight

            // Ensure unique descending values by sorting
            yLabels.sort(function(a, b) { return b - a; });

            // Dynamically update y-axis text elements
            currentWeightText.textContent = yLabels[0];
            textElements.forEach(function(el, index) {
                el.textContent = yLabels[index + 1];
            });
        }

        // Function to animate mobile graph
        function animateMobileGraph() {
            var path = document.getElementById('mobileGraphProgressiveLine');
            var circle = document.getElementById('mobileCircle');
            var goalBox = document.getElementById('mobileGoalBox');
            var goalPointer = document.getElementById('mobileGoalPointer');
            var goalText = document.getElementById('mobileGoalText');
            var currentWeightText = document.getElementById('mobileCurrentWeightText');
            var currentMonthText = document.getElementById('mobileCurrentMonthText');
            var endMonthText = document.getElementById('mobileEndMonthText');
            var textElements = [
                document.getElementById('mobileText2'),
                document.getElementById('mobileText3'),
                document.getElementById('mobileText4'),
                document.getElementById('mobileText5'),
                document.getElementById('mobileText6'),
                document.getElementById('mobileText7')
            ];

            if (!path || !circle || !goalBox || !goalPointer || !goalText || !currentWeightText || !currentMonthText || !endMonthText || textElements.includes(null)) {
                console.error("Some elements not found in the DOM.");
                return;
            }

            var pathLength = path.getTotalLength();
            path.style.transition = path.style.WebkitTransition = 'none';
            path.style.strokeDasharray = pathLength + ' ' + pathLength;
            path.style.strokeDashoffset = pathLength;
            path.getBoundingClientRect();
            path.style.transition = path.style.WebkitTransition = 'stroke-dashoffset 4s ease-in-out';
            path.style.strokeDashoffset = '0';

            function showElements() {
                circle.style.opacity = '1';
                goalBox.style.opacity = '1';
                goalPointer.style.opacity = '1';
                goalText.style.opacity = '1';
                currentMonthText.style.opacity = '1';
                endMonthText.style.opacity = '1';
            }

            path.addEventListener('transitionend', showElements);

            // Pulling from localStorage without default values
            var currentWeight = parseFloat(localStorage.getItem('current_weight'));
            var targetWeight = parseFloat(localStorage.getItem('target_weight'));
            var weightLossPerWeek = 2.88;

            if (isNaN(currentWeight) || isNaN(targetWeight)) {
                console.error("Current weight or target weight not found in localStorage.");
                return;
            }

            currentWeightText.textContent = currentWeight.toFixed(1);
            document.getElementById('mobileGoalWeight').textContent = targetWeight.toFixed(1);

            var totalWeightToLose = currentWeight - targetWeight;
            var totalWeeks = Math.ceil(totalWeightToLose / weightLossPerWeek);

            // Calculate and set the dynamic x-axis dates
            var currentDate = new Date();
            var endDate = new Date(currentDate);
            endDate.setDate(currentDate.getDate() + totalWeeks * 7);

            var startMonth = currentDate.toLocaleString('default', { month: 'long' });
            var endMonth = endDate.toLocaleString('default', { month: 'long' });
            currentMonthText.textContent = startMonth;
            endMonthText.textContent = endMonth;

            // Update y-axis labels dynamically
            var yLabels = [];
            yLabels.push(currentWeight.toFixed(1)); // Starting with the current weight
            for (var i = 1; i < 6; i++) {
                yLabels.push((Math.random() * (currentWeight - targetWeight) + targetWeight).toFixed(1));
            }
            yLabels.push(targetWeight.toFixed(1)); // Ending with the target weight

            // Ensure unique descending values by sorting
            yLabels.sort(function(a, b) { return b - a; });

            // Dynamically update y-axis text elements
            currentWeightText.textContent = yLabels[0];
            textElements.forEach(function(el, index) {
                el.textContent = yLabels[index + 1];
            });
        }

        // Check if the device is mobile or desktop
        if (window.innerWidth <= 768) {
            animateMobileGraph();
        } else {
            animateDesktopGraph();
        }

        // Update the weight and date text dynamically
        $(document).ready(function() {
            var targetWeight = parseFloat(localStorage.getItem('target_weight'));
            if (!isNaN(targetWeight)) {
                var currentDate = new Date();
                var weightLossPerWeek = 2.88;
                var currentWeight = parseFloat(localStorage.getItem('current_weight'));
                var totalWeightToLose = currentWeight - targetWeight;
                var totalWeeks = Math.ceil(totalWeightToLose / weightLossPerWeek);
                var endDate = new Date(currentDate);
                endDate.setDate(currentDate.getDate() + totalWeeks * 7);

                var endMonth = endDate.toLocaleString('default', { month: 'long' });
                var endDay = endDate.getDate();
                var endYear = endDate.getFullYear();

                $('#predictedWeight').text(`${targetWeight.toFixed(1)} lbs by ${endMonth} ${endDay}, ${endYear}`);
            }
        });

        $(document).ready(function() {
            var currentWeight = parseFloat(localStorage.getItem('current_weight'));
            if (!isNaN(currentWeight)) {
                $('.your-weight').text(`Your Weight: ${currentWeight.toFixed(1)} lbs`);
                $('.now-weight').text(`Now: ${currentWeight.toFixed(1)} lbs`);
            } 
        });
    });
    </script>
</body>
</html>
