<!DOCTYPE html>
<html lang="en">

<head>
    <?php include('./assets/includes/style.php'); ?>

    <!-- custom css -->
    <link rel="stylesheet" href="./assets/style.css" />
</head>

<body>

    <!-- header section -->
    <div class="header_sec">
        <div class="heade_img text-center">
            <a href="javascript:history.back()">
                <div class="left_arrow">
                    <svg width="100%" height="100%" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="progress-wrapper__back-arrow">
                        <g clip-path="url(#clip0_1248_6209)">
                            <path d="M19 13C19.5523 13 20 12.5523 20 12C20 11.4477 19.5523 11 19 11V13ZM5.29289 11.2929C4.90237 11.6834 4.90237 12.3166 5.29289 12.7071L11.6569 19.0711C12.0474 19.4616 12.6805 19.4616 13.0711 19.0711C13.4616 18.6805 13.4616 18.0474 13.0711 17.6569L7.41421 12L13.0711 6.34315C13.4616 5.95262 13.4616 5.31946 13.0711 4.92893C12.6805 4.53841 12.0474 4.53841 11.6569 4.92893L5.29289 11.2929ZM19 11L6 11V13L19 13V11Z" fill="#D7D7D7"></path>
                        </g>
                        <defs>
                            <clipPath id="clip0_1248_6209">
                                <rect width="24" height="24" fill="white"></rect>
                            </clipPath>
                        </defs>
                    </svg>
                </div>
            </a>

            <div>
                <img src="./assets/image/logo.png" alt="logo" class="logo-img">
            </div>

            <div class="count_bar">
            </div>
        </div>
    </div>
    <!-- header sec end -->

    <!-- choose sec -->
    <div class="choose_sec">
        <div class="container">
            <div class="choose_head text-center">
                <h2>Enter your email to get your fasting plan!</h2>
            </div>

            <div class="messurement_form mt-5">

                <form class="row emailForm" action="./loading-results-2.php" method="post">

                    <?php foreach ($_POST as $key => $value) {
                        echo '<input type="hidden" name="' . $key . '" value="' . $value . '">';
                    } ?>

                    <div class="col-lg-12 mb-3">
                        <div>
                            <div class="position-relative">
                                <input type="email" class="form-control messure_input" name="email" id="email" placeholder="Your email" />
                            </div>
                        </div>
                    </div>

                    <div>
                        <button type="submit" class="btn messure_btn">Continue</button>
                    </div>

                    <div class="choose_head text-center mt-5">
                        <p>At MyFastingMentor, your personal data is in safe hands. We pledge not to share it with external parties. By entering your email, you consent to possibly receive our service offers, but you can always choose to unsubscribe <br> at any time.</p>
                    </div>

                </form>

            </div>
        </div>
    </div>
    <!-- choose sec end -->

    <?php include('./assets/includes/script.php'); ?>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js"></script>
    <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.emailForm').validate({
                errorElement: 'span',
                errorClass: 'error-inline',
                rules: {
                    email: {
                        required: true,
                        email: true
                    },
                },
                messages: {
                    email: {
                        required: "Please enter your email to continue",
                        email: "Please enter your email to continue"
                    },
                },
                submitHandler: function(form) {
                    // Store email in local storage
                    var email = $('#email').val();
                    localStorage.setItem('userEmail', email);
                    form.submit();
                }
            });
        });
    </script>
</body>
</html>
